/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EnumerationStereotypeModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanStereotypeModelHandler
extends EnumerationStereotypeModelHandler {
    public static final String ID = "BooleanStereotype";

    public BooleanStereotypeModelHandler(String stereotypeName, String featureName) {
        super(stereotypeName, featureName);
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        if (!(objectToEdit instanceof Element)) {
            Activator.log.warn("the element selected is not a UML element: " + objectToEdit);
            return null;
        }
        Element elementToEdit = (Element)objectToEdit;
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype == null) {
            Activator.log.warn("Impossible to find the stereotype " + this.getStereotypeName() + " for the given element" + elementToEdit);
            return null;
        }
        Object value = elementToEdit.getValue(stereotype, this.getFeatureName());
        return value instanceof Boolean ? ((Boolean)value).toString() : value;
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        if (!(objectToEdit instanceof Element)) {
            Activator.log.warn("the element selected is not a UML element: " + objectToEdit);
            return;
        }
        Element elementToEdit = (Element)objectToEdit;
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype == null) {
            Activator.log.warn("Impossible to find the stereotype " + this.getStereotypeName() + " for the given element" + elementToEdit);
            return;
        }
        if (newValue == null || newValue.equals("")) {
            elementToEdit.setValue(stereotype, this.getFeatureName(), null);
        } else if (newValue instanceof String) {
            elementToEdit.setValue(stereotype, this.getFeatureName(), (Object)Boolean.parseBoolean((String)newValue));
        } else if (newValue instanceof Boolean) {
            elementToEdit.setValue(stereotype, this.getFeatureName(), (Object)((Boolean)newValue));
        }
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        Element elementToEdit = this.retrieveElement(objectToEdit);
        if (elementToEdit == null) {
            return;
        }
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype == null) {
            Activator.log.warn("Impossible to find stereotype: " + this.getStereotypeName() + " for element: " + elementToEdit);
            return;
        }
        StructuralFeature featureToEdit = this.retrieveStructuralFeature(elementToEdit, stereotype);
        ArrayList<String> values = new ArrayList<String>();
        if (featureToEdit.getLower() == 0) {
            values.add("");
        }
        values.add("true");
        values.add("false");
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).setAvailableValues(values);
        } else {
            Activator.log.error("Warning: " + descriptor + "could not be completed.", null);
        }
    }

    @Override
    public String getId() {
        return ID;
    }
}

