/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandlerState;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandlerState;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFFeatureModelHandler
implements IEMFModelHandler {
    private final String featureName;
    protected AdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    public static final int NEW_VALUE_NOT_SET_INDEX = -2;
    public static final int SINGLE_VALUE_PROPERTY_INDEX = -1;

    public EMFFeatureModelHandler(String featureName) {
        this.featureName = featureName;
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        return objectToEdit.eGet(featureToEdit);
    }

    @Override
    public abstract void setValueInModel(EObject var1, Object var2);

    @Override
    public abstract void completeEditorDescriptor(IPropertyEditorDescriptor var1, List<? extends EObject> var2);

    public String getFeatureName() {
        return this.featureName;
    }

    public EStructuralFeature getFeatureByName(EObject objectToEdit) {
        return EMFUtils.getFeatureByName(objectToEdit, this.featureName);
    }

    @Override
    public boolean isChangeable(List<? extends EObject> objectsToEdit) {
        if (objectsToEdit.size() < 1) {
            return false;
        }
        EStructuralFeature feature = this.getFeatureByName(objectsToEdit.get(0));
        return feature != null ? feature.isChangeable() : false;
    }

    @Override
    public String getText() {
        return "EMF Handler \"" + this.getId() + "\" -> " + this.getFeatureName();
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/ModelHandler.gif");
    }

    @Override
    public IEMFModelHandlerState createState(boolean readOnly) {
        return new EMFFeatureModelHandlerState(this, readOnly);
    }

    @Override
    public Object getAvailableValues(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            Activator.log.debug("problems during initialization, looking for availables values");
            return null;
        }
        EStructuralFeature feature = this.getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            Activator.log.debug("feature is not a reference, looking for availables values: " + feature);
            return null;
        }
        IItemPropertySource itemPropertySource = (IItemPropertySource)this.factory.adapt((Notifier)eObject, IItemPropertySource.class);
        if (itemPropertySource == null) {
            Activator.log.debug("impossible to find item Property source for " + eObject);
            return null;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = itemPropertySource.getPropertyDescriptor((Object)eObject, (Object)feature);
        if (itemPropertyDescriptor == null) {
            Activator.log.debug("impossible to find item Property descriptor for " + eObject + " and " + feature);
            return null;
        }
        return itemPropertyDescriptor.getChoiceOfValues((Object)eObject);
    }

    @Override
    public void handleNotifyChange(Notification notification, List<? extends EObject> objects, EMFPropertyEditorController adapter) {
        Object notificationFeature = notification.getFeature();
        switch (notification.getEventType()) {
            case 3: {
                for (EObject eObject : objects) {
                    EStructuralFeature feature = this.getFeatureByName(eObject);
                    if (!notificationFeature.equals(feature)) continue;
                    Object newValue = notification.getNewValue();
                    if (newValue instanceof EObject) {
                        ((EObject)newValue).eAdapters().add((Object)adapter);
                    }
                    adapter.refreshDisplay();
                }
                break;
            }
            case 5: {
                for (EObject eObject : objects) {
                    EStructuralFeature feature = this.getFeatureByName(eObject);
                    if (!notificationFeature.equals(feature)) continue;
                    for (Object newValue : (List)notification.getNewValue()) {
                        if (!(newValue instanceof EObject)) continue;
                        ((EObject)newValue).eAdapters().add((Object)adapter);
                    }
                    adapter.refreshDisplay();
                }
                break;
            }
            case 4: {
                for (EObject eObject : objects) {
                    EStructuralFeature feature = this.getFeatureByName(eObject);
                    if (!notificationFeature.equals(feature)) continue;
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof EObject) {
                        ((EObject)oldValue).eAdapters().remove((Object)this);
                    }
                    adapter.refreshDisplay();
                }
                break;
            }
            case 6: {
                for (EObject eObject : objects) {
                    EStructuralFeature feature = this.getFeatureByName(eObject);
                    if (!notificationFeature.equals(feature)) continue;
                    for (Object oldValue : (List)notification.getOldValue()) {
                        if (!(oldValue instanceof EObject)) continue;
                        ((EObject)oldValue).eAdapters().add((Object)adapter);
                    }
                    adapter.refreshDisplay();
                }
                break;
            }
            case 1: 
            case 2: {
                adapter.refreshDisplay();
            }
        }
    }

    @Override
    public void addListenersToModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().add((Object)controller);
        }
    }

    @Override
    public void removeListenersFromModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().remove((Object)controller);
        }
    }

    @Override
    public abstract List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> var1, Composite var2);

    @Override
    public boolean canCreateValueOperations(List<? extends EObject> objectsToEdit) {
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return false;
            }
            if (featureToEdit.isChangeable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IUndoableOperation getDeleteValueOperation(List<? extends EObject> objectsToEdit, Composite parent, List<Integer> indexes) {
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Edit Value");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            IUndoableOperation operation = this.getDeleteStringValueOperation(editingDomain, "Edit Value", eObject, indexes, parent);
            if (operation == null) continue;
            command.add(operation);
        }
        return command.reduce();
    }

    protected IUndoableOperation getDeleteStringValueOperation(TransactionalEditingDomain editingDomain, String string, EObject objectToEdit, List<Integer> indexes, Composite parent) {
        ArrayList newValue;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, string);
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        if (featureToEdit.getUpperBound() == 1) {
            newValue = featureToEdit.getDefaultValue();
        } else {
            ArrayList values = new ArrayList((List)this.getValueToEdit(objectToEdit));
            for (int index : indexes) {
                values.remove(index);
            }
            newValue = values;
        }
        SetRequest[] requests = this.getSetRequest(editingDomain, objectToEdit, newValue);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)objectToEdit);
        if (provider != null) {
            ICommand editCommand = null;
            SetRequest[] setRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                SetRequest current = setRequestArray[n2];
                editCommand = provider.getEditCommand((IEditCommandRequest)current);
                if (editCommand != null && editCommand.canExecute()) {
                    command.add((IUndoableOperation)editCommand);
                }
                ++n2;
            }
        }
        return command;
    }

    @Override
    public boolean canCreateDeleteValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    @Override
    public IUndoableOperation getEditValueOperation(List<? extends EObject> objectsToEdit, int index, Composite parent, Object value) {
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Edit Value");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            IUndoableOperation operation = this.getEditStringValueOperation(editingDomain, "Edit Value", eObject, index, parent, value);
            if (operation == null) continue;
            command.add(operation);
        }
        return command.reduce();
    }

    protected IUndoableOperation getEditStringValueOperation(TransactionalEditingDomain editingDomain, String string, EObject objectToEdit, int index, Composite parent, Object value) {
        ArrayList newValue;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, string);
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        if (featureToEdit.getUpperBound() == 1) {
            newValue = value;
        } else {
            ArrayList values = new ArrayList((List)this.getValueToEdit(objectToEdit));
            values.set(index, value);
            newValue = values;
        }
        SetRequest[] requests = this.getSetRequest(editingDomain, objectToEdit, newValue);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)objectToEdit);
        if (provider != null) {
            ICommand editCommand = null;
            SetRequest[] setRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                SetRequest current = setRequestArray[n2];
                editCommand = provider.getEditCommand((IEditCommandRequest)current);
                if (editCommand != null && editCommand.canExecute()) {
                    command.add((IUndoableOperation)editCommand);
                }
                ++n2;
            }
        }
        return command;
    }

    @Override
    public boolean canCreateEditValueOperation(List<? extends EObject> objectsToEdit) {
        return true;
    }

    protected int getFeatureID(EStructuralFeature feature, BasicEObjectImpl elementToEdit) {
        return elementToEdit.eDerivedStructuralFeatureID(feature);
    }

    protected EStructuralFeature getStructuralFeature(int ID, EObject elementToEdit) {
        if (elementToEdit instanceof BasicEObjectImpl) {
            EClass eClass = elementToEdit.eClass();
            return eClass.getEStructuralFeature(ID);
        }
        return null;
    }

    @Override
    public IUndoableOperation getMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during move operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Move Values");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            IUndoableOperation operation = this.getMoveStringValueOperation(editingDomain, "Move Value", eObject, indexes, parent, delta);
            if (operation == null) continue;
            command.add(operation);
        }
        return command.reduce();
    }

    protected IUndoableOperation getMoveStringValueOperation(TransactionalEditingDomain editingDomain, String string, EObject objectToEdit, List<Integer> indexes, Composite parent, int delta) {
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, string);
        if (this.canMoveStringValue(objectToEdit, indexes, delta)) {
            EClass eClass = objectToEdit.eClass();
            if (eClass == null) {
                return null;
            }
            EStructuralFeature feature = this.getFeatureByName(objectToEdit);
            Object currentValue = objectToEdit.eGet(feature);
            if (currentValue instanceof List) {
                IElementEditService provider;
                List values = (List)currentValue;
                ArrayList<Object> copy = new ArrayList<Object>(values);
                int min = copy.size();
                int max = 0;
                for (int index : indexes) {
                    if (index < min) {
                        min = index;
                    }
                    if (index <= max) continue;
                    max = index;
                }
                max += delta;
                if ((min += delta) < 0) {
                    Activator.log.debug("Trying to move up the elements, with a move which will cause an IndexOutOfBound exception");
                    return null;
                }
                if (max >= copy.size()) {
                    Activator.log.debug("Trying to move down the elements, with a move which will cause an IndexOutOfBound exception");
                    return null;
                }
                if (delta < 0) {
                    this.moveUpElementsInCollection(copy, indexes, delta);
                } else {
                    this.moveDownElementsOperation(copy, indexes, delta);
                }
                SetRequest[] requests = this.getSetRequest(editingDomain, objectToEdit, copy);
                if (requests != null && (provider = ElementEditServiceUtils.getCommandProvider((Object)objectToEdit)) != null) {
                    ICommand editCommand = null;
                    SetRequest[] setRequestArray = requests;
                    int n = requests.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SetRequest current = setRequestArray[n2];
                        editCommand = provider.getEditCommand((IEditCommandRequest)current);
                        if (editCommand != null && editCommand.canExecute()) {
                            command.add((IUndoableOperation)editCommand);
                        }
                        ++n2;
                    }
                }
            }
        }
        return command;
    }

    protected boolean canMoveStringValue(EObject objectToEdit, List<Integer> indexes, int delta) {
        EClass eClass = objectToEdit.eClass();
        if (eClass == null) {
            return false;
        }
        EStructuralFeature feature = this.getFeatureByName(objectToEdit);
        Object currentValue = objectToEdit.eGet(feature);
        if (currentValue instanceof List) {
            List values = (List)currentValue;
            ArrayList copy = new ArrayList(values);
            int min = copy.size();
            int max = 0;
            for (int index : indexes) {
                if (index < min) {
                    min = index;
                }
                if (index <= max) continue;
                max = index;
            }
            max += delta;
            if ((min += delta) < 0) {
                return false;
            }
            if (max >= copy.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canCreateMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during move operation to find the editing domain for objects: " + objectsToEdit, null);
            return false;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Move Values");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return false;
            }
            IUndoableOperation operation = this.getMoveStringValueOperation(editingDomain, "Move Value", eObject, indexes, parent, delta);
            if (operation == null) continue;
            command.add(operation);
        }
        return command.canExecute();
    }

    protected void moveDownElementsOperation(List<Object> modifiedElements, List<Integer> indexes, int move) {
        Collections.sort(indexes);
        Collections.reverse(indexes);
        for (int index : indexes) {
            Object objectToMove = modifiedElements.get(index);
            modifiedElements.remove(index);
            if (index == -1) {
                return;
            }
            modifiedElements.add(index += move, objectToMove);
        }
    }

    protected void moveUpElementsInCollection(List<Object> modifiedElements, List<Integer> indexes, int move) {
        Collections.sort(indexes);
        for (int index : indexes) {
            Object objectToMove = modifiedElements.get(index);
            modifiedElements.remove(index);
            if (index == -1) {
                return;
            }
            modifiedElements.add(index += move, objectToMove);
        }
    }
}

