/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandlerState;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFFeatureModelHandlerState
extends AbstractState
implements IEMFModelHandlerState {
    private EMFFeatureModelHandler modelHandler;
    private PropertyChangeSupport changeSupport;
    private String name;
    private String id;

    public EMFFeatureModelHandlerState(IEMFModelHandler modelHandler, boolean readOnly) {
        super(readOnly);
        assert (modelHandler instanceof EMFFeatureModelHandler);
        this.modelHandler = (EMFFeatureModelHandler)modelHandler;
        this.name = ((EMFFeatureModelHandler)modelHandler).getFeatureName();
        this.id = ((EMFFeatureModelHandler)modelHandler).getId();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public EMFFeatureModelHandler getDescriptor() {
        return this.modelHandler;
    }

    public void setName(String name) {
        this.name = name;
        this.changeSupport.firePropertyChange("name", this.name, this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getEditionDialogId() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Element generateNode(Document document) {
        Element element = document.createElement("feature");
        element.setAttribute("name", this.name);
        element.setAttribute("handlerID", this.id);
        return element;
    }

    @Override
    public List<? extends ITraversableModelElement> getChildren() {
        return Collections.emptyList();
    }

    public void setId(String id) {
        this.id = id;
        this.changeSupport.firePropertyChange("id", this.id, this.id);
    }

    public String getId() {
        return this.id;
    }
}

