/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFStereotypeFeatureModelHandlerState;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandlerState;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFStereotypeFeatureModelHandler
extends EMFFeatureModelHandler {
    private final String stereotypeName;

    @Override
    public void addListenersToModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        super.addListenersToModel(objectsToEdit, controller);
        for (EObject eObject : objectsToEdit) {
            if (!(eObject instanceof Element)) continue;
            Iterator it = ((Element)eObject).getStereotypeApplications().iterator();
            while (it.hasNext()) {
                ((EObject)it.next()).eAdapters().add((Object)controller);
            }
        }
    }

    @Override
    public void removeListenersFromModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        super.removeListenersFromModel(objectsToEdit, controller);
        for (EObject eObject : objectsToEdit) {
            if (!(eObject instanceof Element)) continue;
            Iterator it = ((Element)eObject).getStereotypeApplications().iterator();
            while (it.hasNext()) {
                ((EObject)it.next()).eAdapters().remove((Object)controller);
            }
        }
    }

    public EMFStereotypeFeatureModelHandler(String stereotypeName, String featureName) {
        super(featureName);
        this.stereotypeName = stereotypeName;
    }

    @Override
    public EStructuralFeature getFeatureByName(EObject objectToEdit) {
        if (objectToEdit instanceof Element) {
            return EMFUtils.getStereotypeFeatureByName((Element)objectToEdit, this.retrieveStereotype((Element)objectToEdit), this.getFeatureName());
        }
        Activator.log.error("Impossible to cast into UML element: " + objectToEdit, null);
        return null;
    }

    @Override
    public Object getAvailableValues(EObject eObject) {
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            Activator.log.debug("problems during initialization, looking for availables values");
            return null;
        }
        EStructuralFeature feature = this.getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            Activator.log.debug("feature is not a reference, looking for availables values: " + feature);
            return null;
        }
        IItemPropertySource itemPropertySource = (IItemPropertySource)this.factory.adapt((Notifier)((Element)eObject).getStereotypeApplication(this.retrieveStereotype((Element)eObject)), IItemPropertySource.class);
        if (itemPropertySource == null) {
            Activator.log.debug("impossible to find item Property source for " + this.retrieveStereotype((Element)eObject));
            return null;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = itemPropertySource.getPropertyDescriptor((Object)this.retrieveStereotype((Element)eObject), (Object)feature);
        if (itemPropertyDescriptor == null) {
            Activator.log.debug("impossible to find item Property descriptor for " + this.retrieveStereotype((Element)eObject) + " and " + feature);
            return null;
        }
        return itemPropertyDescriptor.getChoiceOfValues((Object)eObject);
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        if (!(objectToEdit instanceof Element)) {
            Activator.log.warn("the object to edit is not a UML2 Element: " + objectToEdit);
            return null;
        }
        Element elementToEdit = (Element)objectToEdit;
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype != null) {
            return this.getValueForElement(elementToEdit, stereotype);
        }
        Activator.log.warn("Impossible to get the stereotype: " + this.stereotypeName + " on the element: " + elementToEdit + " for feature " + this.getFeatureName());
        return null;
    }

    protected Object getValueForElement(Element elementToEdit, Stereotype stereotype) {
        return elementToEdit.getValue(stereotype, this.getFeatureName());
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        if (!(objectToEdit instanceof Element)) {
            Activator.log.warn("the object to edit is not a UML2 Element: " + objectToEdit);
            return;
        }
        Element elementToEdit = (Element)objectToEdit;
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype != null) {
            this.setValueForElement(elementToEdit, stereotype, newValue);
        } else {
            Activator.log.warn("Impossible to set value to the stereotype: " + this.stereotypeName + " on the element: " + elementToEdit);
        }
    }

    protected void setValueForElement(Element elementToEdit, Stereotype stereotype, Object newValue) {
        elementToEdit.setValue(stereotype, this.getFeatureName(), newValue);
    }

    protected Stereotype retrieveStereotype(Element elementToEdit) {
        return elementToEdit.getAppliedStereotype(this.getStereotypeName());
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
    }

    public String getStereotypeName() {
        return this.stereotypeName;
    }

    @Override
    public boolean isChangeable(List<? extends EObject> objectsToEdit) {
        if (objectsToEdit.size() < 1) {
            return false;
        }
        Element element = this.retrieveElement(objectsToEdit);
        if (element == null) {
            return false;
        }
        Stereotype stereotype = this.retrieveStereotype(element);
        if (stereotype == null) {
            return false;
        }
        StructuralFeature feature = this.retrieveStructuralFeature(element, stereotype);
        return feature != null ? !feature.isReadOnly() : false;
    }

    protected Element retrieveElement(List<? extends EObject> objectToEdit) {
        if (objectToEdit.size() < 1) {
            return null;
        }
        EObject firstObject = objectToEdit.get(0);
        if (!(firstObject instanceof Element)) {
            Activator.log.warn("Object to edit should be a UML2 element: " + firstObject);
            return null;
        }
        Element elementToEdit = (Element)firstObject;
        return elementToEdit;
    }

    protected StructuralFeature retrieveStructuralFeature(Element elementToEdit, Stereotype stereotype) {
        for (Property property : stereotype.getAllAttributes()) {
            if (!this.getFeatureName().equals(property.getName())) continue;
            return property;
        }
        Activator.log.warn("No feature fond with name:" + this.getFeatureName() + " for stereotype " + this.stereotypeName);
        return null;
    }

    @Override
    public IEMFModelHandlerState createState(boolean readOnly) {
        return new EMFStereotypeFeatureModelHandlerState(this, readOnly);
    }

    @Override
    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        return null;
    }
}

