/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFUtils {
    public static EStructuralFeature getFeatureByName(EObject objectToEdit, String featureName) {
        EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            return feature;
        }
        Activator.log.error("impossible to find feature " + featureName + " for object " + objectToEdit, null);
        return null;
    }

    public static EStructuralFeature getStereotypeFeatureByName(Element elementToEdit, Stereotype stereotype, String featureName) {
        EObject eObject = elementToEdit.getStereotypeApplication(stereotype);
        if (eObject == null) {
            Activator.log.error("Impossible to find stereotype application", null);
            return null;
        }
        EClass eClass = eObject.eClass();
        String[] segments = featureName.split("::");
        String segment = segments[0];
        EStructuralFeature eStructuralFeature = null;
        eStructuralFeature = segment.indexOf(91) == -1 ? eClass.getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)segment)) : eClass.getEStructuralFeature(UML2Util.getValidJavaIdentifier((String)segment.substring(0, segment.indexOf(91))));
        if (eStructuralFeature == null) {
            Activator.log.error("Impossible to find structural feature", null);
            return null;
        }
        return eStructuralFeature;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(List<? extends Object> objects) {
        TransactionalEditingDomain editingDomain = null;
        Iterator<? extends Object> it2 = objects.iterator();
        while (it2.hasNext() && editingDomain == null) {
            editingDomain = TransactionUtil.getEditingDomain((Object)it2.next());
        }
        if (editingDomain == null) {
            editingDomain = EditorUtils.getTransactionalEditingDomain();
        }
        return editingDomain;
    }
}

