/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationEMFModelHandler
extends EMFFeatureModelHandler {
    public static final String ID = "Enumeration";

    public EnumerationEMFModelHandler(String featureName) {
        super(featureName);
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        Object value = objectToEdit.eGet(featureToEdit);
        return value instanceof Enumerator ? ((Enumerator)value).getLiteral() : value;
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return;
        }
        if (newValue == null || newValue.equals("")) {
            objectToEdit.eUnset(featureToEdit);
        } else if (newValue instanceof String) {
            EEnum type = (EEnum)featureToEdit.getEType();
            EEnumLiteral literal = type.getEEnumLiteral((String)newValue);
            Enumerator instance = literal.getInstance();
            objectToEdit.eSet(featureToEdit, (Object)instance);
        }
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        if (objectToEdit.size() < 1) {
            return;
        }
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit.get(0));
        if (featureToEdit == null) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (featureToEdit.getLowerBound() == 0) {
            values.add("");
        }
        if (featureToEdit.getEType() instanceof EEnum) {
            EEnum type = (EEnum)featureToEdit.getEType();
            for (EEnumLiteral literal : type.getELiterals()) {
                values.add(literal.getLiteral());
            }
        }
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).setAvailableValues(values);
        } else {
            Activator.log.warn("Warning: " + descriptor + "could not be completed.");
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        ArrayList<IUndoableOperation> operations = new ArrayList<IUndoableOperation>(1);
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        int indexOfNewValue = -2;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Create new Enumeration Value");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            IUndoableOperation operation = this.getCreateEnumerationValueOperation(editingDomain, "Create new Enumeration Value", eObject);
            if (operation == null) continue;
            command.add(operation);
        }
        operations.add((IUndoableOperation)command.reduce());
        return operations;
    }

    protected IUndoableOperation getCreateEnumerationValueOperation(TransactionalEditingDomain editingDomain, String string, EObject objectToEdit) {
        IElementEditService provider;
        ArrayList<Object> newValue;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, string);
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            Activator.log.error("Impossible to find the feature " + this.getFeatureName(), null);
            return command;
        }
        if (featureToEdit.getUpperBound() == 1) {
            newValue = this.getInitialValue(objectToEdit);
        } else {
            ArrayList<Object> values = new ArrayList<Object>((List)this.getValueToEdit(objectToEdit));
            values.add(values.size(), this.getInitialValue(objectToEdit));
            newValue = values;
        }
        SetRequest[] requests = this.getSetRequest(editingDomain, objectToEdit, newValue);
        if (requests != null && (provider = ElementEditServiceUtils.getCommandProvider((Object)objectToEdit)) != null) {
            ICommand editCommand = null;
            SetRequest[] setRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                SetRequest current = setRequestArray[n2];
                editCommand = provider.getEditCommand((IEditCommandRequest)current);
                if (editCommand != null && editCommand.canExecute()) {
                    command.add((IUndoableOperation)editCommand);
                }
                ++n2;
            }
        }
        return command;
    }

    public Object getInitialValue(EObject objectToEdit) {
        String featureName = this.getFeatureName();
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit.getUpperBound() == 1) {
            return featureName;
        }
        EClassifier eClassifier = featureToEdit.getEType();
        if (eClassifier instanceof EEnum) {
            return ((EEnum)eClassifier).getDefaultValue();
        }
        if (Boolean.TYPE.isAssignableFrom(eClassifier.getInstanceClass())) {
            return Boolean.TRUE;
        }
        Activator.log.error("Impossible to find a default value", null);
        return null;
    }

    @Override
    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        if (newValue == null || newValue.equals("")) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, featureToEdit.getDefaultValue())};
        }
        if (newValue instanceof String) {
            EEnum type = (EEnum)featureToEdit.getEType();
            EEnumLiteral literal = type.getEEnumLiteral((String)newValue);
            Enumerator instance = literal.getInstance();
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, (Object)instance)};
        }
        return null;
    }
}

