/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFStereotypeFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationStereotypeModelHandler
extends EMFStereotypeFeatureModelHandler {
    public static final String ID = "EnumerationStereotype";

    public EnumerationStereotypeModelHandler(String stereotypeName, String featureName) {
        super(stereotypeName, featureName);
    }

    @Override
    protected void setValueForElement(Element elementToEdit, Stereotype stereotype, Object newValue) {
        if (newValue == null || newValue.equals("")) {
            elementToEdit.setValue(stereotype, this.getFeatureName(), null);
        } else if (newValue instanceof String) {
            StructuralFeature featureToEdit = this.retrieveStructuralFeature(elementToEdit, stereotype);
            Enumeration type = (Enumeration)featureToEdit.getType();
            EnumerationLiteral literal = type.getOwnedLiteral((String)newValue);
            elementToEdit.setValue(stereotype, this.getFeatureName(), (Object)literal);
        }
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        if (!(objectToEdit instanceof Element)) {
            Activator.log.warn("the element selected is not a UML element: " + objectToEdit);
            return null;
        }
        Element elementToEdit = (Element)objectToEdit;
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype == null) {
            Activator.log.warn("Impossible to find the stereotype " + this.getStereotypeName() + " for the given element" + elementToEdit);
            return null;
        }
        Object value = elementToEdit.getValue(stereotype, this.getFeatureName());
        if (value instanceof EnumerationLiteral) {
            return ((EnumerationLiteral)value).getName();
        }
        if (value instanceof Enumerator) {
            return ((Enumerator)value).getLiteral();
        }
        return value;
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        Element elementToEdit = this.retrieveElement(objectToEdit);
        if (elementToEdit == null) {
            return;
        }
        Stereotype stereotype = this.retrieveStereotype(elementToEdit);
        if (stereotype == null) {
            Activator.log.warn("Impossible to find stereotype: " + this.getStereotypeName() + " for element: " + elementToEdit);
            return;
        }
        StructuralFeature featureToEdit = this.retrieveStructuralFeature(elementToEdit, stereotype);
        ArrayList<String> values = new ArrayList<String>();
        if (featureToEdit.getLower() == 0) {
            values.add("");
        }
        if (featureToEdit.getType() instanceof Enumeration) {
            Enumeration type = (Enumeration)featureToEdit.getType();
            for (EnumerationLiteral literal : type.getOwnedLiterals()) {
                values.add(literal.getName());
            }
        }
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).setAvailableValues(values);
        } else {
            Activator.log.warn("Warning: " + descriptor + "could not be completed.");
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        ArrayList<IUndoableOperation> operations = new ArrayList<IUndoableOperation>(1);
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        int indexOfNewValue = -2;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Create new Enumeration Value");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            CreateEnumerationStereotypeValueOperation operation = new CreateEnumerationStereotypeValueOperation(editingDomain, "Create new Enumeration Value", eObject);
            command.add((IUndoableOperation)operation);
            if (indexOfNewValue != -2) continue;
            indexOfNewValue = operation.getIndexOfNewValue();
        }
        operations.add((IUndoableOperation)command.reduce());
        return operations;
    }

    public Object getInitialValue(EObject objectToEdit) {
        String featureName = this.getFeatureName();
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit.getUpperBound() == 1) {
            return featureName;
        }
        int suffix = 0;
        while (suffix < 1000) {
            EClassifier eClassifier = featureToEdit.getEType();
            if (eClassifier instanceof EEnum) {
                return ((EEnum)eClassifier).getDefaultValue();
            }
            ++suffix;
        }
        Activator.log.error("Impossible to find a default value", null);
        return null;
    }

    protected class CreateEnumerationStereotypeValueOperation
    extends AbstractTransactionalCommand {
        protected final EObject objectToEdit;
        private int indexOfNewValue;

        public CreateEnumerationStereotypeValueOperation(TransactionalEditingDomain domain, String label, EObject objectToEdit) {
            super(domain, label == null ? "" : label, null);
            this.indexOfNewValue = -2;
            this.objectToEdit = objectToEdit;
            EStructuralFeature featureToEdit = EnumerationStereotypeModelHandler.this.getFeatureByName(objectToEdit);
            if (featureToEdit.getUpperBound() == 1) {
                this.indexOfNewValue = -1;
            } else {
                ArrayList values = new ArrayList((List)EnumerationStereotypeModelHandler.this.getValueToEdit(objectToEdit));
                this.indexOfNewValue = values.size();
            }
        }

        public int getIndexOfNewValue() {
            return this.indexOfNewValue;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ArrayList<Object> newValue;
            EStructuralFeature featureToEdit = EnumerationStereotypeModelHandler.this.getFeatureByName(this.objectToEdit);
            if (featureToEdit == null) {
                return CommandResult.newErrorCommandResult((String)("Impossible to find the feature " + EnumerationStereotypeModelHandler.this.getFeatureName()));
            }
            if (featureToEdit.getUpperBound() == 1) {
                newValue = EnumerationStereotypeModelHandler.this.getInitialValue(this.objectToEdit);
            } else {
                ArrayList<Object> values = new ArrayList<Object>((List)EnumerationStereotypeModelHandler.this.getValueToEdit(this.objectToEdit));
                values.add(this.indexOfNewValue, EnumerationStereotypeModelHandler.this.getInitialValue(this.objectToEdit));
                newValue = values;
            }
            EnumerationStereotypeModelHandler.this.setValueInModel(this.objectToEdit, newValue);
            return CommandResult.newOKCommandResult();
        }
    }
}

