/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.DisplayUtils;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.Messages;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceEMFModelHandler
extends EMFFeatureModelHandler {
    public static final String ID = "Reference";

    public ReferenceEMFModelHandler(String featureName) {
        super(featureName);
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return;
        }
        if (newValue instanceof EObject || newValue == null) {
            objectToEdit.eSet(featureToEdit, newValue);
        } else if (newValue instanceof List) {
            objectToEdit.eSet(featureToEdit, newValue);
        } else {
            Activator.log.error("impossible to set the new value", null);
        }
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        EObject eObject = objectsToEdit.get(0);
        EStructuralFeature feature = this.getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            return new ArrayList<IUndoableOperation>();
        }
        boolean isContainment = ((EReference)feature).isContainment();
        if (isContainment) {
            List featureTypeServices;
            ArrayList<IUndoableOperation> undoableOperations = new ArrayList<IUndoableOperation>();
            EClass eClass = eObject.eClass();
            if (eClass == null) {
                return undoableOperations;
            }
            try {
                featureTypeServices = ElementEditServiceUtils.getEditServiceProvider().getContainedTypeEditServices(eObject, (EReference)feature);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return undoableOperations;
            }
            for (IElementEditService featureTypeService : featureTypeServices) {
                CreateElementRequest request = new CreateElementRequest(EMFUtils.getTransactionalEditingDomain(objectsToEdit), eObject, (IElementType)featureTypeService.getAdapter(IElementType.class), (EReference)feature);
                request.setLabel(Messages.bind((String)Messages.EMFTEReferenceController_CreationOperationMenuLabel, (Object)featureTypeService.getDisplayName()));
                ICommand command = featureTypeService.getEditCommand((IEditCommandRequest)request);
                if (!command.canExecute()) continue;
                undoableOperations.add((IUndoableOperation)command);
            }
            return undoableOperations;
        }
        IUndoableOperation operation = this.getFindReferenceCommand(EMFUtils.getTransactionalEditingDomain(objectsToEdit), "Find and Add references", objectsToEdit);
        return Arrays.asList(operation);
    }

    public IUndoableOperation getFindReferenceCommand(TransactionalEditingDomain transactionalEditingDomain, String string, List<? extends EObject> objectsToEdit) {
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(transactionalEditingDomain, string);
        EObject eObject = objectsToEdit.get(0);
        EStructuralFeature feature = this.getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            return command;
        }
        Display display = Display.getCurrent();
        if (display == null && PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        display = display != null ? display : Display.getDefault();
        EClassifier eclassifier = feature.getEType();
        Object availableValues = this.getAvailableValues(eObject);
        List<Object> values = new ArrayList();
        values = availableValues instanceof List ? (List)availableValues : (availableValues instanceof Object[] ? Arrays.asList(availableValues) : Arrays.asList(availableValues));
        FeatureEditorDialog dialog = new FeatureEditorDialog(display.getActiveShell(), DisplayUtils.getLabelProvider(), (Object)eObject, eclassifier, (List)eObject.eGet(feature), Messages.ReferenceEMFModelHandler_Select_Values, values, false, feature.isOrdered(), feature.isUnique());
        if (dialog.open() == 0) {
            IElementEditService provider;
            EList currentValues = dialog.getResult();
            SetRequest[] requests = this.getSetRequest(transactionalEditingDomain, eObject, currentValues);
            if (requests != null && (provider = ElementEditServiceUtils.getCommandProvider((Object)eObject)) != null) {
                ICommand editCommand = null;
                SetRequest[] setRequestArray = requests;
                int n = requests.length;
                int n2 = 0;
                while (n2 < n) {
                    SetRequest current = setRequestArray[n2];
                    editCommand = provider.getEditCommand((IEditCommandRequest)current);
                    if (editCommand != null && editCommand.canExecute()) {
                        command.add((IUndoableOperation)editCommand);
                    }
                    ++n2;
                }
            }
            return command;
        }
        return command;
    }

    @Override
    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        if (newValue instanceof EObject || newValue == null) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, newValue)};
        }
        if (newValue instanceof List) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, newValue)};
        }
        Activator.log.error("impossible to set the new value", null);
        return null;
    }
}

