/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEMFModelHandler
extends EMFFeatureModelHandler {
    public static final String ID = "String";

    public StringEMFModelHandler(String featureName) {
        super(featureName);
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return;
        }
        EClassifier type = featureToEdit.getEType();
        if (type == null) {
            Activator.log.debug("Impossible to find the type of the feature: " + this.getFeatureName());
        } else if (String.class.isAssignableFrom(type.getInstanceClass())) {
            objectToEdit.eSet(featureToEdit, newValue);
        } else if (Integer.TYPE.isAssignableFrom(type.getInstanceClass())) {
            try {
                int value = Integer.parseInt(newValue.toString());
                objectToEdit.eSet(featureToEdit, (Object)value);
            }
            catch (NumberFormatException e) {
                Activator.log.debug(newValue + " can not be parsed as an integer");
            }
        } else {
            Activator.log.error("Feature: " + this.getFeatureName() + ". Impossible to understand the value for the type: " + featureToEdit.getEType().getInstanceClass(), null);
        }
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        ArrayList<IUndoableOperation> operations = new ArrayList<IUndoableOperation>(1);
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Create new String Values");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            IUndoableOperation operation = this.getCreateStringValueCommand(editingDomain, "Create new String Value", eObject);
            if (operation == null) continue;
            command.add(operation);
        }
        operations.add((IUndoableOperation)command.reduce());
        return operations;
    }

    protected IUndoableOperation getCreateStringValueCommand(TransactionalEditingDomain editingDomain, String string, EObject objectToEdit) {
        IElementEditService provider;
        ArrayList<Object> newValue;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, string);
        int indexOfNewValue = -2;
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return command;
        }
        if (featureToEdit.getUpperBound() == 1) {
            indexOfNewValue = -1;
        } else {
            ArrayList values = new ArrayList((List)objectToEdit.eGet(featureToEdit));
            indexOfNewValue = values.size();
        }
        if (featureToEdit.getUpperBound() == 1) {
            newValue = this.getInitialValue(objectToEdit);
        } else {
            ArrayList<Object> values = new ArrayList<Object>((List)objectToEdit.eGet(featureToEdit));
            values.add(indexOfNewValue, this.getInitialValue(objectToEdit));
            newValue = values;
        }
        SetRequest[] requests = this.getSetRequest(editingDomain, objectToEdit, newValue);
        if (requests != null && (provider = ElementEditServiceUtils.getCommandProvider((Object)objectToEdit)) != null) {
            ICommand editCommand = null;
            SetRequest[] setRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                SetRequest current = setRequestArray[n2];
                editCommand = provider.getEditCommand((IEditCommandRequest)current);
                if (editCommand != null && editCommand.canExecute()) {
                    command.add((IUndoableOperation)editCommand);
                }
                ++n2;
            }
        }
        return command;
    }

    public Object getInitialValue(EObject objectToEdit) {
        String featureName = this.getFeatureName();
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit.getUpperBound() == 1) {
            return featureName;
        }
        int suffix = 0;
        while (suffix < 1000) {
            String tmpName = String.valueOf(featureName) + suffix;
            boolean found = false;
            ArrayList values = new ArrayList((List)objectToEdit.eGet(featureToEdit));
            for (Object value : values) {
                if (!tmpName.equals(value)) continue;
                found = true;
            }
            if (!found) {
                return tmpName;
            }
            ++suffix;
        }
        return featureName;
    }

    @Override
    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        EClassifier type = featureToEdit.getEType();
        if (type == null) {
            Activator.log.debug("Impossible to find the type of the feature: " + this.getFeatureName());
            return null;
        }
        if (String.class.isAssignableFrom(type.getInstanceClass())) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, newValue)};
        }
        if (Integer.TYPE.isAssignableFrom(type.getInstanceClass())) {
            try {
                int value = Integer.parseInt(newValue.toString());
                return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, (Object)value)};
            }
            catch (NumberFormatException e) {
                Activator.log.debug(newValue + " can not be parsed as an integer");
            }
        } else {
            Activator.log.error("Feature: " + this.getFeatureName() + ". Impossible to understand the value for the type: " + featureToEdit.getEType().getInstanceClass(), null);
        }
        return null;
    }
}

