/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFStereotypeFeatureModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStereotypeModelHandler
extends EMFStereotypeFeatureModelHandler {
    public static final String ID = "StringStereotype";

    public StringStereotypeModelHandler(String stereotypeName, String featureName) {
        super(stereotypeName, featureName);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        ArrayList<IUndoableOperation> operations = new ArrayList<IUndoableOperation>(1);
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null) {
            Activator.log.error("Impossible during creation operation to find the editing domain for objects: " + objectsToEdit, null);
            return null;
        }
        int indexOfNewValue = -2;
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Create new String Values");
        for (EObject eObject : objectsToEdit) {
            EStructuralFeature featureToEdit = this.getFeatureByName(eObject);
            if (featureToEdit == null) {
                return null;
            }
            CreateStringStererotypeValueOperation operation = new CreateStringStererotypeValueOperation(editingDomain, "Create new String Value", eObject);
            command.add((IUndoableOperation)operation);
            if (indexOfNewValue != -2) continue;
            indexOfNewValue = operation.getIndexOfNewValue();
        }
        operations.add((IUndoableOperation)command.reduce());
        return operations;
    }

    public Object getInitialValue(EObject objectToEdit) {
        String featureName = this.getFeatureName();
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit.getUpperBound() == 1) {
            return featureName;
        }
        int suffix = 0;
        while (suffix < 1000) {
            String tmpName = String.valueOf(featureName) + suffix;
            boolean found = false;
            ArrayList values = new ArrayList((List)this.getValueToEdit(objectToEdit));
            for (Object value : values) {
                if (!tmpName.equals(value)) continue;
                found = true;
            }
            if (!found) {
                return tmpName;
            }
            ++suffix;
        }
        return featureName;
    }

    protected class CreateStringStererotypeValueOperation
    extends AbstractTransactionalCommand {
        protected final EObject objectToEdit;
        private int indexOfNewValue;

        public CreateStringStererotypeValueOperation(TransactionalEditingDomain domain, String label, EObject objectToEdit) {
            super(domain, label == null ? "" : label, null);
            this.indexOfNewValue = -2;
            this.objectToEdit = objectToEdit;
            EStructuralFeature featureToEdit = StringStereotypeModelHandler.this.getFeatureByName(objectToEdit);
            if (featureToEdit.getUpperBound() == 1) {
                this.indexOfNewValue = -1;
            } else {
                ArrayList values = new ArrayList((List)StringStereotypeModelHandler.this.getValueToEdit(objectToEdit));
                this.indexOfNewValue = values.size();
            }
        }

        public int getIndexOfNewValue() {
            return this.indexOfNewValue;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Object newValue;
            EStructuralFeature featureToEdit = StringStereotypeModelHandler.this.getFeatureByName(this.objectToEdit);
            if (featureToEdit == null) {
                return CommandResult.newErrorCommandResult((String)("Impossible to find the feature " + StringStereotypeModelHandler.this.getFeatureName()));
            }
            if (featureToEdit.getUpperBound() == 1) {
                newValue = StringStereotypeModelHandler.this.getInitialValue(this.objectToEdit);
            } else {
                List values = (List)StringStereotypeModelHandler.this.getValueToEdit(this.objectToEdit);
                values.add(this.indexOfNewValue, StringStereotypeModelHandler.this.getInitialValue(this.objectToEdit));
                newValue = values;
            }
            StringStereotypeModelHandler.this.setValueInModel(this.objectToEdit, newValue);
            return CommandResult.newOKCommandResult();
        }
    }
}

