/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractPropertyEditor
implements IDisposable {
    protected static final int TEXT_MARGIN = 5;
    protected static final int LABEL_MAX_WIDTH = 100;
    private PropertyEditorController controller;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private boolean isReadOnly = false;
    private IPropertyEditorDescriptor descriptor = null;
    private String tooltipText = null;

    public AbstractPropertyEditor() {
        this(new TabbedPropertySheetWidgetFactory());
    }

    public AbstractPropertyEditor(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    protected PropertyEditorController getController() {
        return this.controller;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setWidgetFactory(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public void setController(PropertyEditorController controller) {
        this.controller = controller;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String toolTipText) {
        this.tooltipText = toolTipText;
    }

    public abstract Composite createContent(Composite var1);

    public abstract void handleContentChanged();

    public abstract IStatus init(IPropertyEditorDescriptor var1);

    public IPropertyEditorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IPropertyEditorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void dispose();

    public abstract boolean isDisposed();

    protected boolean isValid(Control control) {
        return control != null && !control.isDisposed();
    }

    protected Control createLabel(Composite parent) {
        GridData data = new GridData(4, 0x1000000, false, false);
        String text = this.getDescriptor().getLabel();
        int size = this.computeLabelSize(parent, text);
        data.widthHint = data.minimumWidth = Math.max(100, size);
        return this.createLabel(parent, data);
    }

    protected int computeLabelSize(Composite parent, String text) {
        GC gc = new GC((Drawable)parent);
        FontMetrics fm = gc.getFontMetrics();
        int width = text.length() * fm.getAverageCharWidth();
        gc.dispose();
        return width;
    }

    protected Control createLabel(Composite parent, Object layoutData) {
        CLabel label = this.getWidgetFactory().createCLabel(parent, this.getDescriptor().getLabel());
        if (this.getDescriptor().getLabelImageDescriptor() != null) {
            label.setImage(Activator.getImageFromDescriptor(this.getDescriptor().getLabelImageDescriptor()));
        }
        label.setToolTipText(this.getTooltipText());
        label.setLayoutData(layoutData);
        return label;
    }
}

