/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.ILabelProviderController;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTablePropertyEditor
extends AbstractPropertyEditor {
    protected Composite composite;
    protected Button addButton;
    protected Button removeButton;
    protected Table table;
    protected TableViewer viewer;
    protected List<Object> currentValue;

    @Override
    public Composite createContent(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent, 0);
        int columnNu = this.getColumnNumber();
        GridLayout layout = new GridLayout(columnNu, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)data);
        this.createLabel(this.composite);
        if (!this.getIsReadOnly()) {
            this.addButton = this.getWidgetFactory().createButton(this.composite, "", 0);
            this.addButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Add_12x12.gif")));
            data = new GridData(4, 0x1000000, false, false);
            this.addButton.setLayoutData((Object)data);
            this.addButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    AbstractTablePropertyEditor.this.performAddButtonPressed();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            this.removeButton = this.getWidgetFactory().createButton(this.composite, "", 0);
            this.removeButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Delete_12x12.gif")));
            data = new GridData(4, 0x1000000, false, false);
            this.removeButton.setLayoutData((Object)data);
            this.removeButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    AbstractTablePropertyEditor.this.performRemoveButtonPressed();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            if (this.getController().canMoveValues(new ArrayList(), 0)) {
                Button upButton = this.getWidgetFactory().createButton(this.composite, "", 0);
                upButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Up_12x12.gif")));
                data = new GridData(4, 0x1000000, false, false);
                upButton.setLayoutData((Object)data);
                upButton.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                        AbstractTablePropertyEditor.this.performUpButtonPressed();
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                Button downButton = this.getWidgetFactory().createButton(this.composite, "", 0);
                downButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Down_12x12.gif")));
                data = new GridData(4, 0x1000000, false, false);
                downButton.setLayoutData((Object)data);
                downButton.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                        AbstractTablePropertyEditor.this.performDownButtonPressed();
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
            }
        }
        Composite tableComposite = this.getWidgetFactory().createComposite(this.composite, 0);
        data = new GridData(4, 4, true, true, columnNu, 1);
        data.heightHint = 80;
        data.widthHint = 200;
        tableComposite.setLayoutData((Object)data);
        this.table = new Table(tableComposite, 2050);
        this.viewer = new TableViewer(this.table);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100, 0, true));
        tableColumn.setText("Value");
        tableViewerColumn.setEditingSupport(this.createEditingSupport());
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        if (this.getController() instanceof ILabelProviderController) {
            this.viewer.setLabelProvider((IBaseLabelProvider)((ILabelProviderController)((Object)this.getController())).getEditorLabelProvider());
        } else {
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        }
        this.viewer.getControl().setToolTipText(this.getTooltipText());
        return this.composite;
    }

    protected abstract EditingSupport createEditingSupport();

    protected void performAddButtonPressed() {
        Display display = Display.getCurrent();
        if (display == null && PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        display = display != null ? display : Display.getDefault();
        List operations = this.getController().getCreateValueOperations();
        if (operations == null || operations.isEmpty()) {
            return;
        }
        if (operations.size() == 1) {
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)operations.get(0), (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e1) {
                Activator.log.error((Throwable)e1);
            }
        } else {
            Menu menu = new Menu((Control)this.addButton);
            for (IUndoableOperation operation : operations) {
                MenuItem item = new MenuItem(menu, 0);
                item.setText(operation.getLabel());
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            CheckedOperationHistory.getInstance().execute(operation, (IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ExecutionException e1) {
                            Activator.log.error((Throwable)e1);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            menu.setVisible(true);
        }
        int lastIndex = this.table.getItemCount() - 1;
        this.table.select(lastIndex);
    }

    protected void performRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        int[] selectedIndexes = this.table.getSelectionIndices();
        Arrays.sort(selectedIndexes);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = selectedIndexes.length - 1;
        while (i >= 0) {
            indexes.add(selectedIndexes[i]);
            --i;
        }
        IUndoableOperation operation = this.getController().getDeleteValueOperation(indexes);
        if (operation != null && operation.canExecute()) {
            try {
                CheckedOperationHistory.getInstance().execute(operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    protected void performUpButtonPressed() {
        int[] selectionIndices = this.table.getSelectionIndices();
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        ArrayList<Integer> newSelectionList = new ArrayList<Integer>();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            selectionList.add(i);
            newSelectionList.add(i - 1);
            ++n2;
        }
        IUndoableOperation moveOperation = this.getController().getMoveCurrentValuesOperation(selectionList, -1);
        if (moveOperation != null && moveOperation.canExecute()) {
            try {
                CheckedOperationHistory.getInstance().execute(moveOperation, (IProgressMonitor)new NullProgressMonitor(), null);
                int[] newSelection = new int[newSelectionList.size()];
                int i = 0;
                while (i < newSelectionList.size()) {
                    newSelection[i] = (Integer)newSelectionList.get(i);
                    ++i;
                }
                this.table.select(newSelection);
            }
            catch (ExecutionException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    protected void performDownButtonPressed() {
        int[] selectionIndices = this.table.getSelectionIndices();
        ArrayList<Integer> selectionList = new ArrayList<Integer>();
        ArrayList<Integer> newSelectionList = new ArrayList<Integer>();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            selectionList.add(i);
            newSelectionList.add(i + 1);
            ++n2;
        }
        IUndoableOperation moveOperation = this.getController().getMoveCurrentValuesOperation(selectionList, 1);
        if (moveOperation != null && moveOperation.canExecute()) {
            try {
                CheckedOperationHistory.getInstance().execute(moveOperation, (IProgressMonitor)new NullProgressMonitor(), null);
                int[] newSelection = new int[newSelectionList.size()];
                int i = 0;
                while (i < newSelectionList.size()) {
                    newSelection[i] = (Integer)newSelectionList.get(i);
                    ++i;
                }
                this.table.select(newSelection);
            }
            catch (ExecutionException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    @Override
    protected Control createLabel(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
        return this.createLabel(parent, data);
    }

    protected int getColumnNumber() {
        if (this.getIsReadOnly()) {
            return 1;
        }
        if (this.getController().canMoveValues(new ArrayList(), 0)) {
            return 5;
        }
        return 3;
    }

    @Override
    public void handleContentChanged() {
        this.getController().updateModel();
    }

    @Override
    public IStatus init(IPropertyEditorDescriptor descriptor) {
        this.setDescriptor(descriptor);
        this.setTooltipText(descriptor.getTooltipText());
        return Status.OK_STATUS;
    }

    @Override
    public List<Object> getValue() {
        return this.currentValue;
    }

    @Override
    public void setValue(Object valueToEdit) {
        if (!this.isValid((Control)this.table)) {
            return;
        }
        if (valueToEdit instanceof List) {
            this.currentValue = (List)valueToEdit;
        } else if (valueToEdit == null) {
            this.currentValue = null;
        } else {
            Activator.log.error(valueToEdit + " is not a list of Object for current table: " + this.getDescriptor().getLabel(), null);
        }
        this.viewer.setInput(this.currentValue != null ? this.currentValue : Collections.emptyList());
    }

    @Override
    public void dispose() {
        if (this.isValid((Control)this.composite)) {
            this.composite.dispose();
            this.composite = null;
            this.setController(null);
        }
    }

    @Override
    public boolean isDisposed() {
        if (this.composite == null) {
            return true;
        }
        return this.composite.isDisposed();
    }
}

