/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.IPropertyEditorTypeValidator;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptorFactory;

public class PropertyEditorConfiguration {
    protected String description;
    protected ImageDescriptor descriptor;
    protected boolean allowMultiValue;
    protected IPropertyEditorTypeValidator validator;
    protected String id;
    protected IConfigurationElement element;
    protected IPropertyEditorDescriptorFactory factory;

    protected void setElement(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ImageDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isAllowMultiValue() {
        return this.allowMultiValue;
    }

    public void setAllowMultiValue(boolean allowMultiValue) {
        this.allowMultiValue = allowMultiValue;
    }

    public IPropertyEditorTypeValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IPropertyEditorTypeValidator validator) {
        this.validator = validator;
    }

    public static PropertyEditorConfiguration parse(IConfigurationElement element) throws CoreException {
        PropertyEditorConfiguration configuration = new PropertyEditorConfiguration();
        configuration.setId(element.getAttribute("id"));
        configuration.setDescription(element.getAttribute("description"));
        configuration.setAllowMultiValue(Boolean.getBoolean(element.getAttribute("allowMultiValue")));
        configuration.setValidator((IPropertyEditorTypeValidator)element.createExecutableExtension("typeValidator"));
        configuration.setElement(element);
        configuration.setDescriptorFactory((IPropertyEditorDescriptorFactory)element.createExecutableExtension("factory"));
        assert (configuration.getId() != null) : "impossible to get the identifier for the provider " + element.getName();
        assert (configuration.getValidator() != null) : "impossible to get the validor for the provider " + element.getName();
        return configuration;
    }

    protected void setDescriptorFactory(IPropertyEditorDescriptorFactory factory) {
        this.factory = factory;
    }

    public IPropertyEditorDescriptorFactory getDescriptorFactory() {
        return this.factory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public AbstractPropertyEditor instanciateEditor() throws CoreException {
        return (AbstractPropertyEditor)this.getElement().createExecutableExtension("class");
    }
}

