/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.CreatePropertyEditorDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.propertyeditor.CreatePropertyEditorOperation;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorConfiguration;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.w3c.dom.Node;

public class PropertyEditorProvider
extends AbstractProvider {
    private Map<String, PropertyEditorConfiguration> editors = new HashMap<String, PropertyEditorConfiguration>();

    public AbstractPropertyEditor createPropertyEditor(String editorIdentifier, PropertyEditorController controller) {
        PropertyEditorConfiguration configuration;
        block4: {
            configuration = this.editors.get(editorIdentifier);
            if (configuration != null) break block4;
            Activator.log.error("impossible to find the configuration for editor " + editorIdentifier, null);
            return null;
        }
        try {
            AbstractPropertyEditor editor = configuration.instanciateEditor();
            if (editor instanceof AbstractPropertyEditor) {
                editor.setController(controller);
                return editor;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public void configure(IConfigurationElement providerConfiguration) {
        try {
            IConfigurationElement[] iConfigurationElementArray = providerConfiguration.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("PropertyEditor".equals(element.getName())) {
                    PropertyEditorConfiguration configuration = PropertyEditorConfiguration.parse(element);
                    this.editors.put(configuration.getId(), configuration);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public IPropertyEditorDescriptor createPropertyEditorDescriptor(String editorID, Node editorNode) {
        PropertyEditorConfiguration configuration = this.editors.get(editorID);
        if (configuration != null) {
            return configuration.getDescriptorFactory().createEditorDescriptor(editorNode);
        }
        return null;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreatePropertyEditorOperation) {
            CreatePropertyEditorOperation createPropertyEditorOperation = (CreatePropertyEditorOperation)operation;
            String operationIdentifier = createPropertyEditorOperation.getEditorIdentifier();
            return this.editors.containsKey(operationIdentifier);
        }
        if (operation instanceof CreatePropertyEditorDescriptorOperation) {
            CreatePropertyEditorDescriptorOperation editorDescriptorOperation = (CreatePropertyEditorDescriptorOperation)operation;
            return this.editors.containsKey(editorDescriptorOperation.getEditorId());
        }
        return false;
    }
}

