/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.CreatePropertyEditorDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.propertyeditor.CreatePropertyEditorOperation;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorProvider;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Node;

public class PropertyEditorService
extends Service {
    protected static PropertyEditorService instance;

    protected PropertyEditorService() {
    }

    public static synchronized PropertyEditorService getInstance() {
        if (instance == null) {
            instance = new PropertyEditorService();
            instance.configureProviders("org.eclipse.papyrus.properties.runtime", "propertyEditorProvider");
        }
        return instance;
    }

    public AbstractPropertyEditor createPropertyEditor(PropertyEditorController controller, String id, TabbedPropertySheetWidgetFactory widgetFactory) {
        List results = this.execute(ExecutionStrategy.FORWARD, new CreatePropertyEditorOperation(controller, id));
        if (results == null || results.size() == 0) {
            Activator.log.error("impossible to create the editor using id " + id, null);
            return null;
        }
        Object result = results.get(0);
        if (result instanceof AbstractPropertyEditor) {
            ((AbstractPropertyEditor)result).setWidgetFactory(widgetFactory);
            return (AbstractPropertyEditor)result;
        }
        Activator.log.error("impossible to create the editor using id " + id, null);
        return null;
    }

    public IPropertyEditorDescriptor createPropertyEditorDescriptor(String editorID, Node editorNode) {
        List results = this.execute(ExecutionStrategy.FORWARD, new CreatePropertyEditorDescriptorOperation(editorID, editorNode));
        if (results == null || results.size() == 0) {
            throw new RuntimeException("Impossible to create this property editor: " + editorID);
        }
        IPropertyEditorDescriptor descriptor = (IPropertyEditorDescriptor)results.get(0);
        return (IPropertyEditorDescriptor)results.get(0);
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (operation instanceof CreatePropertyEditorOperation || operation instanceof CreatePropertyEditorDescriptorOperation) {
                return this.getProvider().provides(operation);
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof PropertyEditorProvider) {
                    PropertyEditorProvider defaultProvider = (PropertyEditorProvider)newProvider;
                    defaultProvider.configure(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

