/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioBoxPropertyEditor
extends AbstractPropertyEditor {
    public static final String ID = "org.eclipse.papyrus.properties.runtime.radioBoxPropertyEditor";
    protected Composite composite;
    protected List<String> values = new ArrayList<String>();
    protected List<Button> buttons = new ArrayList<Button>();
    protected SelectionListener listener = new RadioButtonListener();

    @Override
    public Composite createContent(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent, 0);
        int columnNu = this.getColumnNumber();
        GridLayout layout = new GridLayout(columnNu, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)data);
        if ((this.getDescriptor().getLabelPosition() & 0x4080) != 0) {
            this.createLabel(this.composite);
        }
        for (String value : this.values) {
            Button button = this.getWidgetFactory().createButton(this.composite, !value.equals("") ? value : "<Unset>", 16);
            if (!this.getIsReadOnly()) {
                button.setEnabled(true);
                button.addSelectionListener(this.listener);
            } else {
                button.setEnabled(false);
            }
            this.buttons.add(button);
            button.setToolTipText(this.getTooltipText());
        }
        if ((this.getDescriptor().getLabelPosition() & 0x20400) != 0) {
            this.createLabel(this.composite);
        }
        return this.composite;
    }

    protected int getColumnNumber() {
        return this.values.size() + ((this.getDescriptor().getLabelPosition() & 0x20000 | 0x4000) != 0 ? 1 : 0);
    }

    @Override
    public void dispose() {
        if (this.isValid((Control)this.composite)) {
            this.composite.dispose();
            this.composite = null;
            this.buttons.clear();
            this.listener = null;
            this.setController(null);
        }
    }

    @Override
    public boolean isDisposed() {
        if (this.composite == null) {
            return true;
        }
        return this.composite.isDisposed();
    }

    @Override
    public Object getValue() {
        if (this.isValid(this.buttons)) {
            for (Button button : this.buttons) {
                if (!button.getSelection()) continue;
                return this.values.get(this.buttons.indexOf(button));
            }
        } else {
            Activator.log.error("trying to read the value of the combo whereas the combo is disposed", null);
        }
        return null;
    }

    @Override
    public void handleContentChanged() {
        this.getController().updateModel();
    }

    @Override
    public IStatus init(IPropertyEditorDescriptor descriptor) {
        this.setDescriptor(descriptor);
        this.setTooltipText(descriptor.getTooltipText());
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            if (((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).getAvailableValues() != null) {
                for (Object object : ((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).getAvailableValues()) {
                    this.values.add(object.toString());
                }
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.papyrus.properties.runtime", "Impossible to initialize the editor using descriptor :" + descriptor);
    }

    @Override
    public void setValue(Object valueToEdit) {
        if (!this.isValid(this.buttons)) {
            return;
        }
        if (valueToEdit instanceof String) {
            String newValue = (String)valueToEdit;
            int index = this.values.indexOf(newValue);
            if (index >= 0) {
                for (Button button : this.buttons) {
                    button.setSelection(false);
                }
                this.buttons.get(index).setSelection(true);
            } else {
                Activator.log.error("Impossible to get the value " + valueToEdit + " in the list of available values", null);
            }
        }
    }

    protected boolean isValid(List<Button> buttons) {
        return buttons != null && !buttons.isEmpty() && !buttons.get(0).isDisposed();
    }

    protected class RadioButtonListener
    implements SelectionListener {
        protected RadioButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            for (Button button : RadioBoxPropertyEditor.this.buttons) {
                button.setSelection(false);
            }
            ((Button)e.widget).setSelection(true);
            RadioBoxPropertyEditor.this.handleContentChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

