/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.IBoundedValuesController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.dialogs.ReferenceExplorerDialog;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SimpleReferencePropertyEditor
extends AbstractPropertyEditor {
    public static final String ID = "org.eclipse.papyrus.properties.runtime.simpleReferencePropertyEditor";
    protected Composite composite;
    protected Button addButton;
    protected Button removeButton;
    protected CLabel referenceArea;
    protected Object currentValue;

    public Composite createContent(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent, 0);
        int columnNu = this.getColumnNumber();
        GridLayout layout = new GridLayout(columnNu, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)data);
        if ((this.getDescriptor().getLabelPosition() & 0x4080) != 0) {
            this.createLabel(this.composite);
        }
        this.referenceArea = this.getWidgetFactory().createCLabel(this.composite, "", 2048);
        data = new GridData(4, 4, true, true);
        this.referenceArea.setLayoutData((Object)data);
        this.referenceArea.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                SimpleReferencePropertyEditor.this.openPropertyDialog();
            }
        });
        this.referenceArea.setToolTipText(this.getTooltipText());
        this.addButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.addButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Add_12x12.gif")));
        data = new GridData(4, 0x1000000, false, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SimpleReferencePropertyEditor.this.openReferenceDialog();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addButton.setEnabled(!this.getIsReadOnly());
        this.removeButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.removeButton.setImage(Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.properties.runtime", (String)"icons/Delete_12x12.gif")));
        data = new GridData(4, 0x1000000, false, false);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SimpleReferencePropertyEditor.this.removeValueAction();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.removeButton.setEnabled(!this.getIsReadOnly());
        if ((this.getDescriptor().getLabelPosition() & 0x20400) != 0) {
            this.createLabel(this.composite);
        }
        return this.composite;
    }

    protected void removeValueAction() {
        this.currentValue = null;
        this.getController().updateModel();
    }

    protected void openPropertyDialog() {
    }

    protected void openReferenceDialog() {
        Shell currentShell = this.getShell();
        ReferenceExplorerDialog dialog = new ReferenceExplorerDialog(currentShell, (IBoundedValuesController)((Object)this.getController()), false);
        if (dialog.open() == 0) {
            this.currentValue = dialog.getFirstResult();
            this.getController().updateModel();
        }
    }

    protected Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null && PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        display = display != null ? display : Display.getDefault();
        return display.getActiveShell();
    }

    protected Control createLabel(Composite parent) {
        GridData data = new GridData(16384, 0x1000000, false, false, this.getColumnNumber() == 3 ? 3 : 1, 1);
        String text = this.getDescriptor().getLabel();
        int size = this.computeLabelSize(parent, text);
        data.widthHint = data.minimumWidth = Math.max(100, size);
        return this.createLabel(parent, data);
    }

    protected int getColumnNumber() {
        if ((this.getDescriptor().getLabelPosition() & 0x480) != 0) {
            return 3;
        }
        return 4;
    }

    public void handleContentChanged() {
        this.getController().updateModel();
    }

    public IStatus init(IPropertyEditorDescriptor descriptor) {
        this.setDescriptor(descriptor);
        this.setTooltipText(descriptor.getTooltipText());
        return Status.OK_STATUS;
    }

    public Object getValue() {
        if (this.isValid((Control)this.referenceArea)) {
            return this.currentValue;
        }
        Activator.log.error("trying to read the value of the reference area whereas the combo is disposed", null);
        return null;
    }

    public void setValue(Object valueToEdit) {
        if (!this.isValid((Control)this.referenceArea)) {
            return;
        }
        this.currentValue = valueToEdit;
        if (valueToEdit != null) {
            this.referenceArea.setText(((IBoundedValuesController)((Object)this.getController())).getEditorLabelProvider().getText(valueToEdit));
            this.referenceArea.setImage(((IBoundedValuesController)((Object)this.getController())).getEditorLabelProvider().getImage(valueToEdit));
        } else {
            this.referenceArea.setText("<Undefined>");
            this.referenceArea.setImage(null);
        }
    }

    public void setController(PropertyEditorController controller) {
        assert (controller instanceof IBoundedValuesController) : "Controller should be a IboundedValuesController";
        super.setController(controller);
    }

    public void dispose() {
        if (this.isValid((Control)this.composite)) {
            this.composite.dispose();
            this.composite = null;
            this.setController(null);
        }
    }

    public boolean isDisposed() {
        if (this.composite == null) {
            return false;
        }
        return this.composite.isDisposed();
    }
}

