/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.PropertyEditorDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextPropertyEditor
extends AbstractPropertyEditor {
    public static final String ID = "org.eclipse.papyrus.properties.runtime.textPropertyEditor";
    private Text text;
    private Composite composite;

    public void handleContentChanged() {
        this.getController().updateModel();
    }

    public IStatus init(IPropertyEditorDescriptor descriptor) {
        this.setDescriptor((PropertyEditorDescriptor)descriptor);
        this.setTooltipText(descriptor.getTooltipText());
        return Status.OK_STATUS;
    }

    public Composite createContent(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent, 0);
        int columnNu = this.getColumnNumber();
        GridLayout layout = new GridLayout(columnNu, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)data);
        if ((this.getDescriptor().getLabelPosition() & 0x4080) != 0) {
            this.createLabel(this.composite);
        }
        this.text = this.getWidgetFactory().createText(this.composite, "", 2048);
        data = new GridData(4, 4, true, false);
        this.text.setLayoutData((Object)data);
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TextPropertyEditor.this.handleContentChanged();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (13 == e.keyCode && e.stateMask == 0) {
                    TextPropertyEditor.this.handleContentChanged();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.text.setEnabled(!this.getIsReadOnly());
        if ((this.getDescriptor().getLabelPosition() & 0x20400) != 0) {
            this.createLabel(this.composite);
        }
        this.text.setToolTipText(this.getTooltipText());
        return this.composite;
    }

    protected int getColumnNumber() {
        if ((this.getDescriptor().getLabelPosition() & 0x480) != 0) {
            return 1;
        }
        return 2;
    }

    public Object getValue() {
        if (this.isValid((Control)this.text)) {
            return this.text.getText();
        }
        Activator.log.error("trying to read the value of the text area whereas the control is disposed", null);
        return null;
    }

    public void setValue(Object valueToEdit) {
        if (this.isValid((Control)this.text)) {
            String textToEdit = valueToEdit != null ? valueToEdit.toString() : "";
            this.text.setText(textToEdit);
        }
    }

    public void dispose() {
        if (this.isValid((Control)this.composite)) {
            this.composite.dispose();
            this.composite = null;
            this.setController(null);
        }
    }

    public PropertyEditorDescriptor getDescriptor() {
        return (PropertyEditorDescriptor)super.getDescriptor();
    }

    public boolean isDisposed() {
        if (this.composite == null) {
            return true;
        }
        return this.composite.isDisposed();
    }
}

