/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.PropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorDescriptorState
extends AbstractState {
    private PropertyEditorDescriptor descriptor;
    private PropertyChangeSupport changeSupport;
    private String id;
    private String label;
    private int labelPosition;

    public PropertyEditorDescriptorState(PropertyEditorDescriptor descriptor, boolean readOnly) {
        super(readOnly);
        this.descriptor = descriptor;
        this.id = descriptor.getEditorId();
        this.label = descriptor.getLabel();
        this.labelPosition = descriptor.getLabelPosition();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.changeSupport.firePropertyChange("id", this.id, this.id);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.changeSupport.firePropertyChange("label", this.label, this.label);
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
        this.changeSupport.firePropertyChange("labelPosition", this.labelPosition, this.labelPosition);
    }

    @Override
    public PropertyEditorDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getEditionDialogId() {
        return "";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Node generateNode(Document document) {
        Element node = document.createElement("editor");
        node.setAttribute("id", this.id);
        node.setAttribute("label", this.label);
        node.setAttribute("labelPosition", "" + this.labelPosition);
        return node;
    }

    @Override
    public List<? extends ITraversableModelElement> getChildren() {
        return Collections.emptyList();
    }
}

