/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptorFactory;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.PropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.RadioBoxPropertyEditorDescriptor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RadioBoxPropertyEditorDescriptorFactory
implements IPropertyEditorDescriptorFactory {
    public PropertyEditorDescriptor createEditorDescriptor(Node editorNode) {
        String identifier = "";
        String label = "";
        String tooltipText = "";
        int labelPosition = 16384;
        ImageDescriptor imageDescriptor = null;
        NamedNodeMap attributes = editorNode.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String nodeName = attribute.getNodeName();
                if ("label".equals(nodeName)) {
                    label = attribute.getNodeValue();
                } else if ("labelPosition".equals(nodeName)) {
                    labelPosition = Integer.parseInt(attribute.getNodeValue());
                } else if ("id".equals(nodeName)) {
                    identifier = attribute.getNodeValue();
                } else if ("tooltip".equals(nodeName)) {
                    tooltipText = attribute.getNodeValue();
                }
                ++i;
            }
        }
        NodeList children = editorNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap iconAttributes;
            Node child = children.item(i);
            if ("icon".equals(child.getNodeName()) && (iconAttributes = child.getAttributes()) != null) {
                int j = 0;
                while (j < iconAttributes.getLength()) {
                    Node pluginIDNode = iconAttributes.getNamedItem("pluginID");
                    Node pathNode = iconAttributes.getNamedItem("path");
                    if (pluginIDNode != null && pathNode != null) {
                        imageDescriptor = Activator.imageDescriptorFromPlugin((String)pluginIDNode.getNodeValue(), (String)pathNode.getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new RadioBoxPropertyEditorDescriptor(identifier, label, labelPosition, tooltipText, imageDescriptor);
    }
}

