/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.runtime.view.AbstractConstrainedDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewProviderParser;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogDescriptor
extends AbstractConstrainedDescriptor {
    protected List<IFragmentDescriptor> fragmentDescriptors;
    protected Object title;
    protected Object message;
    protected List<String> replacedDialogIds;

    public DialogDescriptor(String id, List<IConstraintDescriptor> constraints, Node contentNode, int selectionSize, List<String> replacedDialogIds, Object title, Object message, PropertyViewProviderParser parser) {
        super(id, constraints, contentNode, selectionSize, parser);
        this.replacedDialogIds = replacedDialogIds;
        this.title = title;
        this.message = message;
    }

    public List<IFragmentDescriptor> getFragmentDescriptors() {
        if (this.unparsed) {
            if (this.parser == null) {
                this.fragmentDescriptors = Collections.emptyList();
                Activator.log.error("No parser was given to the fragment descriptor " + this.id, null);
                this.parseFailed = true;
            } else {
                try {
                    this.fragmentDescriptors = this.parser.parseDialogContentNode(this.contentNode);
                    this.parseFailed = false;
                }
                catch (XMLParseException e) {
                    Activator.log.error((Throwable)e);
                    this.parseFailed = true;
                }
            }
        }
        return this.fragmentDescriptors;
    }

    public Object getTitle() {
        return this.title;
    }

    public Object getMessage() {
        return this.message;
    }

    public List<String> getReplacedDialogIds() {
        return this.replacedDialogIds;
    }

    @Override
    public String getText() {
        return "DialogDescriptor";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public IState createState(boolean readOnly) {
        return null;
    }
}

