/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.AbstractConstrainedDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewProviderParser;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentDescriptor
extends AbstractConstrainedDescriptor
implements IFragmentDescriptor {
    protected List<ContainerDescriptor> descriptors;

    public FragmentDescriptor(String id, List<IConstraintDescriptor> constraints, List<ContainerDescriptor> descriptors, int selectionSize) {
        super(id, constraints, selectionSize);
        this.descriptors = descriptors;
    }

    public FragmentDescriptor(String id, List<IConstraintDescriptor> constraints, Node contentNode, int selectionSize, PropertyViewProviderParser parser) {
        super(id, constraints, contentNode, selectionSize, parser);
    }

    @Override
    public List<ContainerDescriptor> getContainerDescriptors() {
        if (this.unparsed && !this.parseFailed) {
            if (this.parser == null) {
                this.descriptors = Collections.emptyList();
                Activator.log.error("No parser was given to the view descriptor " + this.id, null);
                this.parseFailed = true;
            } else {
                try {
                    this.descriptors = this.parser.parseFragmentContentNode(this.contentNode);
                    this.parseFailed = false;
                }
                catch (XMLParseException e) {
                    Activator.log.error((Throwable)e);
                    this.parseFailed = true;
                }
            }
        }
        return this.descriptors;
    }

    @Override
    public String getText() {
        return "Fragment: " + this.getId();
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/Fragment.gif");
    }

    @Override
    public FragmentDescriptorState createState(boolean readOnly) {
        return new FragmentDescriptorState(this, readOnly);
    }
}

