/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentDescriptorState
extends AbstractState
implements IFragmentDescriptorState {
    private FragmentDescriptor descriptor;
    private final List<ContainerDescriptorState> containerDescriptorStates = new ArrayList<ContainerDescriptorState>();
    private final List<ConstraintDescriptorState> constraintDescriptorStates = new ArrayList<ConstraintDescriptorState>();
    private int selectionSize;
    private PropertyChangeSupport changeSupport;
    private String id;

    public FragmentDescriptorState(FragmentDescriptor descriptor, boolean readOnly) {
        super(readOnly);
        this.descriptor = descriptor;
        this.id = descriptor.getId();
        List<ContainerDescriptor> containerDescriptors = descriptor.getContainerDescriptors();
        for (ContainerDescriptor containerDescriptor : containerDescriptors) {
            this.containerDescriptorStates.add(containerDescriptor.createState(readOnly));
        }
        for (IConstraintDescriptor constraintDescriptor : descriptor.getConstraintDescriptors()) {
            this.getConstraintDescriptorStates().add(constraintDescriptor.createState(readOnly));
        }
        this.selectionSize = descriptor.getSelectionSize();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public FragmentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getSelectionSize() {
        return this.selectionSize;
    }

    public void setSelectionSizeState(int selectionSize) {
        int oldSize = this.selectionSize;
        this.selectionSize = selectionSize;
        this.changeSupport.firePropertyChange("selectionSize", oldSize, this.selectionSize);
    }

    @Override
    public List<ContainerDescriptorState> getContainerDescriptorStates() {
        return this.containerDescriptorStates;
    }

    public List<ConstraintDescriptorState> getConstraintDescriptorStates() {
        return this.constraintDescriptorStates;
    }

    @Override
    public String getEditionDialogId() {
        return "FragmentDescriptorStateDialog";
    }

    @Override
    public String getText() {
        return "Fragment: " + this.getId() + " (size: " + this.getSelectionSize() + ")";
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addContainerDescriptorState(ContainerDescriptorState containerDescriptorState) {
        this.containerDescriptorStates.add(containerDescriptorState);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, this.containerDescriptorStates);
    }

    public void removeContainerDescriptorState(ContainerDescriptorState containerDescriptorState) {
        this.containerDescriptorStates.remove(containerDescriptorState);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, this.containerDescriptorStates);
    }

    public void addConstraintDescriptorState(ConstraintDescriptorState constraintDescriptorState) {
        this.constraintDescriptorStates.add(constraintDescriptorState);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, constraintDescriptorState);
    }

    public void removeContainerDescriptorState(ConstraintDescriptorState constraintDescriptorState) {
        this.constraintDescriptorStates.remove(constraintDescriptorState);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, constraintDescriptorState);
    }

    public List<ContainerDescriptorState> getChildren() {
        return this.getContainerDescriptorStates();
    }

    @Override
    public Node generateNode(Document document) {
        Element node = document.createElement("fragment");
        this.generateAttributes(node, document);
        this.generateConstraints(node, document);
        this.generateContainers(node, document);
        return node;
    }

    protected void generateAttributes(Element node, Document document) {
        node.setAttribute("id", this.getId());
    }

    protected void generateConstraints(Element node, Document document) {
        Element contentElement = document.createElement("context");
        contentElement.setAttribute("enablesFor", "" + this.getSelectionSize());
        for (ConstraintDescriptorState state : this.getConstraintDescriptorStates()) {
            contentElement.appendChild(state.generateNode(document));
        }
        node.appendChild(contentElement);
    }

    protected void generateContainers(Element node, Document document) {
        Element contentElement = document.createElement("content");
        for (ContainerDescriptorState state : this.getContainerDescriptorStates()) {
            contentElement.appendChild(state.generateNode(document));
        }
        node.appendChild(contentElement);
    }

    public void setId(String id) {
        this.id = id;
        this.changeSupport.firePropertyChange("id", this.id, this.id);
    }

    public String getId() {
        return this.id;
    }
}

