/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedFragmentDescriptor
implements IFragmentDescriptor {
    private String predefinedId;
    private boolean parseFailed = false;
    private IFragmentDescriptor descriptor = null;

    public PredefinedFragmentDescriptor(String predefinedId) {
        this.predefinedId = predefinedId;
    }

    @Override
    public String getText() {
        return "PredefinedFragment: " + this.predefinedId;
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/PredefinedFragment.gif");
    }

    @Override
    public IFragmentDescriptorState createState(boolean readOnly) {
        return new PredefinedFragmentDescriptorState(this, readOnly);
    }

    @Override
    public List<ContainerDescriptor> getContainerDescriptors() {
        if (this.descriptor == null && !this.parseFailed) {
            this.descriptor = PropertyViewService.getInstance().getFragmentDescriptor(this.predefinedId);
            if (this.descriptor == null) {
                this.parseFailed = true;
            }
        }
        if (this.descriptor != null) {
            return this.descriptor.getContainerDescriptors();
        }
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.predefinedId;
    }
}

