/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedFragmentDescriptorState
extends AbstractState
implements IFragmentDescriptorState {
    private final PredefinedFragmentDescriptor predefinedFragmentDescriptor;
    private final List<ContainerDescriptorState> containerDescriptorStates = new ArrayList<ContainerDescriptorState>();

    public PredefinedFragmentDescriptorState(PredefinedFragmentDescriptor predefinedFragmentDescriptor, boolean readOnly) {
        super(readOnly);
        this.predefinedFragmentDescriptor = predefinedFragmentDescriptor;
        for (ContainerDescriptor containerDescriptor : predefinedFragmentDescriptor.getContainerDescriptors()) {
            this.getContainerDescriptorStates().add(containerDescriptor.createState(true));
        }
    }

    @Override
    public List<? extends ITraversableModelElement> getChildren() {
        return this.getContainerDescriptorStates();
    }

    @Override
    public PredefinedFragmentDescriptor getDescriptor() {
        return this.predefinedFragmentDescriptor;
    }

    @Override
    public String getEditionDialogId() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public List<ContainerDescriptorState> getContainerDescriptorStates() {
        return this.containerDescriptorStates;
    }

    @Override
    public Node generateNode(Document document) {
        Element element = document.createElement("fragment");
        element.setAttribute("predefinedId", this.getDescriptor().getId());
        return element;
    }
}

