/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.dialogs.EMFFeatureBindingLabelProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ExpandableContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.GroupContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutParser;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyViewProviderParser {
    protected static final String DIALOGS_NODE_NAME = "dialogs";
    protected static final String NODE_NAME_FRAGMENTS = "fragments";
    protected static final String NODE_NAME_TAB = "tab";
    protected static final String NODE_NAME_FRAGMENT = "fragment";
    protected static final String NODE_NAME_ID = "id";
    protected static final String XML_PATH = "path";
    protected static final String NODE_NAME_DIALOG = "dialog";
    protected static final String ATTRIBUTE_PREDEFINED_ID = "predefinedId";
    protected Map<String, FragmentDescriptor> predefinedFragments;
    protected Bundle bundle;
    protected Map<String, DialogDescriptor> predefinedDialogs;

    protected FragmentDescriptor parseFragment(Node fragmentNode) throws XMLParseException {
        Node idNode;
        NamedNodeMap attributes = fragmentNode.getAttributes();
        if (attributes != null) {
            idNode = attributes.getNamedItem(NODE_NAME_ID);
            if (idNode == null) {
                throw new XMLParseException("Impossible to find ID for fragment " + fragmentNode);
            }
        } else {
            throw new XMLParseException("Impossible to find ID for fragment " + fragmentNode);
        }
        String id = idNode.getNodeValue();
        NodeList children = fragmentNode.getChildNodes();
        Node contextNode = null;
        Node contentNode = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String childNodeName = child.getNodeName();
            if ("context".equals(childNodeName)) {
                contextNode = child;
            } else if ("content".equals(childNodeName)) {
                contentNode = child;
            }
            ++i;
        }
        if (contextNode == null || contentNode == null) {
            Activator.log.error("Impossible to parse configuration for " + fragmentNode, null);
            return null;
        }
        List<IConstraintDescriptor> constraints = this.parseConstraints(contextNode);
        int selectionSize = this.parseSelectionSize(contextNode);
        return new FragmentDescriptor(id, constraints, contentNode, selectionSize, this);
    }

    protected List<String> parseReplacedDialogs(Node contextNode) {
        ArrayList<String> replacedDialogIds = new ArrayList<String>();
        NodeList childrenNodes = contextNode.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node childNode = childrenNodes.item(i);
            String childNodeName = childNode.getNodeName();
            if ("replacedDialogs".equals(childNodeName)) {
                NodeList replacedDialogNodes = childNode.getChildNodes();
                int j = 0;
                while (j < replacedDialogNodes.getLength()) {
                    Node idNode;
                    NamedNodeMap attributes;
                    Node replacedDialogNode = replacedDialogNodes.item(j);
                    if ("replacedDialog".equals(replacedDialogNode.getNodeName()) && (attributes = replacedDialogNode.getAttributes()) != null && (idNode = attributes.getNamedItem(NODE_NAME_ID)) != null) {
                        replacedDialogIds.add(idNode.getNodeValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return replacedDialogIds;
    }

    protected int parseSelectionSize(Node contextNode) {
        NamedNodeMap contextAttributes = contextNode.getAttributes();
        Node isMultiNode = contextAttributes.getNamedItem("enablesFor");
        String isMultiValue = isMultiNode.getNodeValue();
        return Integer.parseInt(isMultiValue);
    }

    protected List<IConstraintDescriptor> parseConstraints(Node contextNode) {
        ArrayList<IConstraintDescriptor> constraintDescriptors = new ArrayList<IConstraintDescriptor>();
        NodeList children2 = contextNode.getChildNodes();
        Class elementClass = null;
        int j = 0;
        while (j < children2.getLength()) {
            Node child2 = children2.item(j);
            if ("elementClass".equals(child2.getNodeName())) {
                if (child2.getAttributes() != null && child2.getAttributes().getNamedItem("name") != null) {
                    String elementClassName = child2.getAttributes().getNamedItem("name").getNodeValue();
                    try {
                        elementClass = this.bundle.loadClass(elementClassName);
                        constraintDescriptors.add(new ObjectTypeConstraintDescriptor(elementClass));
                    }
                    catch (ClassNotFoundException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            } else if ("appliedStereotypes".equals(child2.getNodeName())) {
                ArrayList<String> appliedStereotypeQNames = new ArrayList<String>();
                NodeList stereotypeNodes = child2.getChildNodes();
                int i = 0;
                while (i < stereotypeNodes.getLength()) {
                    Node qualifiedName;
                    NamedNodeMap attributes;
                    Node stereotypeNode = stereotypeNodes.item(i);
                    String stereotypeNodeName = stereotypeNode.getNodeName();
                    if ("appliedStereotype".equals(stereotypeNodeName) && (attributes = stereotypeNode.getAttributes()) != null && (qualifiedName = attributes.getNamedItem("qualifiedName")) != null) {
                        appliedStereotypeQNames.add(qualifiedName.getNodeValue());
                    }
                    ++i;
                }
                constraintDescriptors.add(new AppliedStereotypeConstraintDescriptor(appliedStereotypeQNames));
            }
            ++j;
        }
        return constraintDescriptors;
    }

    public void parseXMLfile(Document document, Map<String, FragmentDescriptor> predefinedFragments, Map<String, DialogDescriptor> predefinedDialogs) throws XMLParseException {
        this.predefinedFragments = predefinedFragments;
        this.predefinedDialogs = predefinedDialogs;
        NodeList roots = document.getChildNodes();
        int i = 0;
        while (i < roots.getLength()) {
            Node fragmentsOrDialogsNode = roots.item(i);
            String topNodeName = fragmentsOrDialogsNode.getNodeName();
            if (NODE_NAME_FRAGMENTS.equals(topNodeName)) {
                this.parseFragmentsNode(fragmentsOrDialogsNode);
            } else if (DIALOGS_NODE_NAME.equals(topNodeName)) {
                this.parseDialogsNode(fragmentsOrDialogsNode);
            }
            ++i;
        }
    }

    protected void parseDialogsNode(Node dialogNode) throws XMLParseException {
        String pluginId = this.getPluginIdFromTopNode(dialogNode);
        this.bundle = Platform.getBundle((String)pluginId);
        NodeList children = dialogNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            DialogDescriptor dialogDescriptor;
            Node childNode = children.item(i);
            String childNodeName = childNode.getNodeName();
            if (NODE_NAME_DIALOG.equals(childNodeName) && (dialogDescriptor = this.parseDialogNode(childNode)) != null) {
                this.predefinedDialogs.put(dialogDescriptor.getId(), dialogDescriptor);
            }
            ++i;
        }
    }

    protected DialogDescriptor parseDialogNode(Node dialogNode) throws XMLParseException {
        Node idNode;
        NamedNodeMap attributes = dialogNode.getAttributes();
        if (attributes != null) {
            idNode = attributes.getNamedItem(NODE_NAME_ID);
            if (idNode == null) {
                throw new XMLParseException("Impossible to find ID for dialog " + dialogNode);
            }
        } else {
            throw new XMLParseException("Impossible to find ID for dialog " + dialogNode);
        }
        String id = idNode.getNodeValue();
        NodeList children = dialogNode.getChildNodes();
        Node contextNode = null;
        Node contentNode = null;
        Node titleNode = null;
        Node messageNode = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String childNodeName = child.getNodeName();
            if ("context".equals(childNodeName)) {
                contextNode = child;
            } else if ("content".equals(childNodeName)) {
                contentNode = child;
            } else if ("title".equals(childNodeName)) {
                titleNode = child;
            } else if ("message".equals(childNodeName)) {
                messageNode = child;
            }
            ++i;
        }
        if (contextNode == null || contentNode == null || titleNode == null || messageNode == null) {
            Activator.log.error("Impossible to parse configuration for " + dialogNode, null);
            return null;
        }
        List<IConstraintDescriptor> constraints = this.parseConstraints(contextNode);
        int selectionSize = this.parseSelectionSize(contextNode);
        List<String> replacedDialogIds = this.parseReplacedDialogs(contextNode);
        Object message = this.parseStringNode(messageNode);
        Object title = this.parseStringNode(titleNode);
        return new DialogDescriptor(id, constraints, contentNode, selectionSize, replacedDialogIds, title, message, this);
    }

    protected Object parseStringNode(Node titleNode) {
        NodeList children = titleNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String childNodeName = child.getNodeName();
            if ("string".equals(childNodeName)) {
                NamedNodeMap attributes = child.getAttributes();
                if (attributes != null) {
                    Node valueNode = attributes.getNamedItem("value");
                    return valueNode != null ? valueNode.getNodeValue() : "";
                }
                Activator.log.warn("no attribute for title Node: " + titleNode);
            } else if ("emfMessageBinding".equals(childNodeName)) {
                return this.parseEMFBindingNode(child);
            }
            ++i;
        }
        return null;
    }

    protected Object parseEMFBindingNode(Node messageBindingNode) {
        Node valueNode;
        String message = null;
        ArrayList<String> featureNames = new ArrayList<String>();
        NamedNodeMap attributes = messageBindingNode.getAttributes();
        if (attributes != null) {
            valueNode = attributes.getNamedItem("message");
            if (valueNode == null) {
                Activator.log.warn("ParseBindingNode: No value for message node : " + messageBindingNode);
                return null;
            }
        } else {
            Activator.log.warn("ParseBindingNode: No attributes for node: " + messageBindingNode);
            return null;
        }
        message = valueNode.getNodeValue();
        NodeList childNodes = messageBindingNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            String childNodeName = child.getNodeName();
            if ("feature".equals(childNodeName)) {
                attributes = child.getAttributes();
                if (attributes != null) {
                    Node valueNode2 = attributes.getNamedItem("name");
                    if (valueNode2 != null) {
                        featureNames.add(valueNode2.getNodeValue());
                    }
                } else {
                    Activator.log.warn("ParseBindingNode: No attributes for feature node: " + child);
                }
            }
            ++i;
        }
        return new EMFFeatureBindingLabelProviderDescriptor(message, featureNames.toArray(new String[0]));
    }

    protected void parseFragmentsNode(Node fragmentNode) throws XMLParseException {
        String pluginId = this.getPluginIdFromTopNode(fragmentNode);
        this.bundle = Platform.getBundle((String)pluginId);
        NodeList children = fragmentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            FragmentDescriptor fragmentDescriptor;
            Node childNode = children.item(i);
            String childNodeName = childNode.getNodeName();
            if (NODE_NAME_FRAGMENT.equals(childNodeName) && (fragmentDescriptor = this.parseFragment(childNode)) != null) {
                this.predefinedFragments.put(fragmentDescriptor.getId(), fragmentDescriptor);
            }
            ++i;
        }
    }

    protected String getPluginIdFromTopNode(Node topNode) throws XMLParseException {
        Node pluginIdNode;
        NamedNodeMap attributes = topNode.getAttributes();
        if (attributes != null && (pluginIdNode = attributes.getNamedItem("pluginId")) != null) {
            return pluginIdNode.getNodeValue();
        }
        throw new XMLParseException("impossible to find plugin id for top node: " + topNode);
    }

    public List<ContainerDescriptor> parseFragmentContentNode(Node unparsedContentNode) throws XMLParseException {
        ArrayList<ContainerDescriptor> containerDescriptors = new ArrayList<ContainerDescriptor>();
        NodeList children = unparsedContentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node containerNode = children.item(i);
            if ("container".equals(containerNode.getNodeName())) {
                containerDescriptors.add(this.parseContainerNode(containerNode));
            } else if ("expandableContainer".equals(containerNode.getNodeName())) {
                containerDescriptors.add(this.parseExpandableContainerNode(containerNode));
            } else if ("groupContainer".equals(containerNode.getNodeName())) {
                containerDescriptors.add(this.parseGroupNode(containerNode));
            }
            ++i;
        }
        return containerDescriptors;
    }

    protected ContainerDescriptor parseContainerNode(Node containerNode) throws XMLParseException {
        Node layoutNode = this.getLayoutNode(containerNode);
        LayoutDescriptor layoutDescriptor = this.parseLayoutNode(layoutNode);
        return new ContainerDescriptor(layoutDescriptor, containerNode);
    }

    protected Node getLayoutNode(Node containerNode) {
        NodeList children = containerNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("layout".equals(child.getNodeName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected ContainerDescriptor parseGroupNode(Node containerNode) throws XMLParseException {
        Node layoutNode = this.getLayoutNode(containerNode);
        LayoutDescriptor layoutDescriptor = this.parseLayoutNode(layoutNode);
        String label = this.parseLabel(containerNode);
        return new GroupContainerDescriptor(layoutDescriptor, label, containerNode);
    }

    protected ContainerDescriptor parseExpandableContainerNode(Node containerNode) throws XMLParseException {
        Node layoutNode = this.getLayoutNode(containerNode);
        LayoutDescriptor layoutDescriptor = this.parseLayoutNode(layoutNode);
        String label = this.parseLabel(containerNode);
        return new ExpandableContainerDescriptor(layoutDescriptor, label, containerNode);
    }

    protected String parseLabel(Node containerNode) throws XMLParseException {
        NamedNodeMap attributes = containerNode.getAttributes();
        if (attributes == null) {
            throw new XMLParseException("Impossible to find attributes for container node " + containerNode);
        }
        Node nameNode = attributes.getNamedItem("label");
        String label = "";
        if (nameNode == null) {
            throw new XMLParseException("Impossible to find layout attribute for container node " + containerNode);
        }
        label = nameNode.getNodeValue();
        return label;
    }

    protected LayoutDescriptor parseLayoutNode(Node layoutNode) throws XMLParseException {
        return LayoutParser.parseLayoutNode(layoutNode);
    }

    public List<IFragmentDescriptor> parseDialogContentNode(Node contentNode) throws XMLParseException {
        ArrayList<IFragmentDescriptor> fragmentDescriptors = new ArrayList<IFragmentDescriptor>();
        try {
            NodeList children = contentNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (NODE_NAME_FRAGMENT.equals(childNode.getNodeName())) {
                    IFragmentDescriptor descriptor = this.parseFragmentOrPredefinedFragment(childNode);
                    fragmentDescriptors.add(descriptor);
                }
                ++i;
            }
        }
        catch (XMLParseException e) {
            Activator.log.error("Problem during parsing of replaced sections for node " + contentNode, (Throwable)e);
        }
        return fragmentDescriptors;
    }

    protected IFragmentDescriptor parseFragmentOrPredefinedFragment(Node fragmentNode) throws XMLParseException {
        Node attribute;
        NamedNodeMap attributes = fragmentNode.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(ATTRIBUTE_PREDEFINED_ID)) != null) {
            return new PredefinedFragmentDescriptor(attribute.getNodeValue());
        }
        FragmentDescriptor fragmentDescriptor = this.parseFragment(fragmentNode);
        this.predefinedFragments.put(fragmentDescriptor.getId(), fragmentDescriptor);
        return fragmentDescriptor;
    }
}

