/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.dialogs.GetDialogDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.dialogs.GetDialogDescriptorOperationById;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.GetAllFragmentDescriptorsOperation;
import org.eclipse.papyrus.properties.runtime.view.GetFragmentDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.view.IPropertyViewOperation;
import org.eclipse.papyrus.properties.runtime.view.IPropertyViewProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyViewService
extends Service
implements IEclipsePreferences.IPreferenceChangeListener {
    protected static PropertyViewService instance;

    protected PropertyViewService() {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.papyrus.properties.runtime");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public static synchronized PropertyViewService getInstance() {
        if (instance == null) {
            instance = new PropertyViewService();
            instance.configureProviders("org.eclipse.papyrus.properties.runtime", "propertyViewProvider");
        }
        return instance;
    }

    public List<ProviderDescriptor> getPropertyViewProviders() {
        return this.findAllProviders();
    }

    public PropertyEditorController createPropertyEditorController(List<Object> objectsToEdit, Composite parent, IPropertyEditorControllerDescriptor controllerDescriptor, TabbedPropertySheetWidgetFactory widgetFactory) {
        PropertyEditorController controller = PropertyEditorControllerService.getInstance().createPropertyEditorController(objectsToEdit, parent, controllerDescriptor);
        if (controller != null) {
            controller.createPropertyEditor(controllerDescriptor.getEditorDescriptor(), widgetFactory);
        }
        return controller;
    }

    public DialogDescriptor getDialogDescriptor(String dialogID) {
        DialogDescriptor descriptor = (DialogDescriptor)this.executeUnique(ExecutionStrategy.REVERSE, new GetDialogDescriptorOperationById(dialogID));
        return descriptor;
    }

    public DialogDescriptor getDialogDescriptor(List<Object> objectsToEdit) {
        List validDescriptors = this.execute(ExecutionStrategy.REVERSE, new GetDialogDescriptorOperation(objectsToEdit));
        ArrayList<DialogDescriptor> filteredDescriptors = new ArrayList<DialogDescriptor>();
        List subList = this.flattenList(validDescriptors);
        if (subList.isEmpty()) {
            return null;
        }
        for (DialogDescriptor currentDescriptor : subList) {
            boolean isRemoved = false;
            String currentId = currentDescriptor.getId();
            for (DialogDescriptor descriptor : subList) {
                if (!descriptor.getReplacedDialogIds().contains(currentId)) continue;
                isRemoved = true;
            }
            if (isRemoved) continue;
            filteredDescriptors.add(currentDescriptor);
        }
        if (filteredDescriptors.isEmpty()) {
            return (DialogDescriptor)subList.get(0);
        }
        return (DialogDescriptor)filteredDescriptors.get(0);
    }

    public FragmentDescriptor getFragmentDescriptor(String id) {
        FragmentDescriptor result = (FragmentDescriptor)this.executeUnique(ExecutionStrategy.REVERSE, new GetFragmentDescriptorOperation(id));
        return result;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public List<?> findAllProviders() {
        return super.getAllProviders();
    }

    public Map<String, FragmentDescriptor> getAllFragmentDescriptors() {
        List fragmentDescriptors = this.execute(ExecutionStrategy.FORWARD, new GetAllFragmentDescriptorsOperation());
        return this.flattenMap(fragmentDescriptors);
    }

    public <T> List<T> flattenList(List<List<T>> descriptors) {
        ArrayList<T> flattenList = new ArrayList<T>();
        for (List<T> list : descriptors) {
            flattenList.addAll(list);
        }
        return flattenList;
    }

    public <T, V> Map<T, V> flattenMap(List<Map<T, V>> descriptors) {
        HashMap<T, V> flattenMap = new HashMap<T, V>();
        for (Map<T, V> map : descriptors) {
            flattenMap.putAll(map);
        }
        return flattenMap;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("propertyViewCustomizations".equals(event.getKey())) {
            for (Object descriptor : this.getAllProviders()) {
                if (!(descriptor instanceof ProviderDescriptor)) continue;
                ((ProviderDescriptor)((Object)descriptor)).resetProvider();
            }
            this.providerChanged(new ProviderChangeEvent((IProvider)this));
        }
    }

    public static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (operation instanceof IPropertyViewOperation) {
                return this.getProvider().provides(operation);
            }
            return false;
        }

        public void resetProvider() {
            this.provider = null;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IPropertyViewProvider) {
                    ((IPropertyViewProvider)newProvider).configure(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

