/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.dialogs.GetDialogDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.dialogs.GetDialogDescriptorOperationById;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.GetAllFragmentDescriptorsOperation;
import org.eclipse.papyrus.properties.runtime.view.GetFragmentDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.view.IPropertyViewProvider;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewProviderParser;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyViewProvider
extends AbstractProvider
implements IPropertyViewProvider {
    protected static final String TAB_ID = "tabId";
    protected static final String ADAPTER_ID = "adapterId";
    protected static final String SECTION_NODE_NAME = "section";
    protected static final String NODE_NAME_TAB = "tab";
    protected static final String NODE_NAME_FRAGMENT = "view";
    protected static final String NODE_NAME_ID = "id";
    protected static final String XML_PATH = "path";
    protected static final String PROPERTY_VIEW_CONTRIBUTION = "PropertyViewContribution";
    protected static final String ICON = "icon";
    protected static final String DESCRIPTION = "description";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected static final String CATEGORY = "category";
    protected static final String LABEL = "label";
    public static final String MEMENTO_PATH = "path";
    public static final String PROPERTY_VIEW_CUSTOMIZATIONS_ID = "propertyViewCustomizations";
    public static final String PROPERTY_VIEW_CUSTOMIZATION = "propertyViewCustomization";
    protected String name;
    protected String id;
    protected ImageDescriptor iconDescriptor = null;
    protected String description;
    protected PropertyViewProviderParser parser = null;
    protected final Map<String, FragmentDescriptor> predefinedFragments = new HashMap<String, FragmentDescriptor>();
    protected final Map<String, DialogDescriptor> predefinedDialogs = new HashMap<String, DialogDescriptor>();

    public PropertyViewProviderParser getParser() {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    protected PropertyViewProviderParser createParser() {
        return new PropertyViewProviderParser();
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetFragmentDescriptorOperation) {
            return this.managesFragmentDescriptor(((GetFragmentDescriptorOperation)operation).getDescriptorID());
        }
        if (operation instanceof GetDialogDescriptorOperationById) {
            return this.managesDialogDescriptor(((GetDialogDescriptorOperationById)operation).getDescriptorID());
        }
        if (operation instanceof GetDialogDescriptorOperation) {
            return true;
        }
        return operation instanceof GetAllFragmentDescriptorsOperation;
    }

    public String getContributionName() {
        return this.name;
    }

    public ImageDescriptor getIconDescriptor() {
        return this.iconDescriptor;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void configure(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        if (bundle == null) {
            Activator.log.warn("Ignoring extension " + element + ". Impossible to find bundle " + bundle);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (PROPERTY_VIEW_CONTRIBUTION.equals(child.getName())) {
                this.name = child.getAttribute(NAME);
                this.description = child.getAttribute(DESCRIPTION);
                String iconPath = child.getAttribute(ICON);
                if (iconPath != null) {
                    this.iconDescriptor = Activator.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                try {
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    String path = child.getAttribute("path");
                    InputStream stream = this.getXmlFile(child, path, bundle);
                    if (stream == null) {
                        throw new IOException("Impossible to load file: " + path);
                    }
                    Document document = documentBuilder.parse(stream);
                    this.getParser().parseXMLfile(document, this.predefinedFragments, this.predefinedDialogs);
                }
                catch (ParserConfigurationException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (SAXException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (XMLParseException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public InputStream getXmlFile(IConfigurationElement element, String path, Bundle bundle) throws IOException {
        String filePath;
        URL urlFile = bundle.getEntry(path);
        urlFile = FileLocator.resolve((URL)urlFile);
        if ("file".equals((urlFile = FileLocator.toFileURL((URL)urlFile)).getProtocol())) {
            return new FileInputStream(new File(urlFile.getFile()));
        }
        if ("jar".equals(urlFile.getProtocol()) && (filePath = urlFile.getPath()).startsWith("file:")) {
            int jarPathEndIndex = filePath.indexOf("!/");
            if (jarPathEndIndex < 0) {
                Activator.log.error("Impossible to find the jar path end", null);
                return null;
            }
            String jarPath = filePath.substring("file:".length(), jarPathEndIndex);
            ZipFile zipFile = new ZipFile(jarPath);
            filePath = filePath.substring(jarPathEndIndex + 2, filePath.length());
            ZipEntry entry = zipFile.getEntry(filePath);
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    @Override
    public FragmentDescriptor getFragmentDescriptor(String descriptorID) {
        return this.predefinedFragments.get(descriptorID);
    }

    @Override
    public Map<String, FragmentDescriptor> getAllFragmentDescriptors() {
        return this.predefinedFragments;
    }

    @Override
    public boolean managesFragmentDescriptor(String descriptorId) {
        return this.predefinedFragments.containsKey(descriptorId);
    }

    @Override
    public DialogDescriptor getDialogDescriptor(String descriptorID) {
        return this.predefinedDialogs.get(descriptorID);
    }

    @Override
    public List<DialogDescriptor> getDialogDescriptor(List<Object> objectsToEdit) {
        ArrayList<DialogDescriptor> validDescriptors = new ArrayList<DialogDescriptor>();
        for (DialogDescriptor descriptor : this.predefinedDialogs.values()) {
            if (!this.isValid(descriptor, objectsToEdit)) continue;
            validDescriptors.add(descriptor);
        }
        return validDescriptors;
    }

    protected boolean isValid(DialogDescriptor descriptor, List<Object> objectsToEdit) {
        for (IConstraintDescriptor constraintDescriptor : descriptor.getConstraintDescriptors()) {
            for (Object objectToEdit : objectsToEdit) {
                boolean isValid = constraintDescriptor.select(objectToEdit);
                if (isValid) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean managesDialogDescriptor(String descriptorId) {
        return this.predefinedDialogs.containsKey(descriptorId);
    }
}

