/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.constraints;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppliedStereotypeConstraintDescriptor
implements IConstraintDescriptor,
IConfigurableDescriptor {
    private final List<String> stereotypeQualifiedNames;

    public AppliedStereotypeConstraintDescriptor(List<String> stereotypeQualifiedNames) {
        this.stereotypeQualifiedNames = stereotypeQualifiedNames;
    }

    @Override
    public boolean select(Object objectToTest) {
        if (objectToTest instanceof org.eclipse.uml2.uml.Element) {
            org.eclipse.uml2.uml.Element elementToTest = (org.eclipse.uml2.uml.Element)objectToTest;
            for (String stQualifiedName : this.getStereotypeQualifiedNames()) {
                Stereotype st = elementToTest.getAppliedStereotype(stQualifiedName);
                if (st != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String> getStereotypeQualifiedNames() {
        return this.stereotypeQualifiedNames;
    }

    @Override
    public String getText() {
        return "Stereotypes Constraint: " + this.getStereotypeQualifiedNames();
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/StereotypeConstraint.gif");
    }

    @Override
    public AppliedStereotypeConstraintDescriptorState createState(boolean readOnly) {
        return new AppliedStereotypeConstraintDescriptorState(this, readOnly);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AppliedStereotypeConstraintDescriptorState
    extends ConstraintDescriptorState {
        private PropertyChangeSupport changeSupport;
        private List<String> stereotypesToApply;

        public AppliedStereotypeConstraintDescriptorState(AppliedStereotypeConstraintDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.stereotypesToApply = new ArrayList<String>();
            this.stereotypesToApply.addAll(descriptor.getStereotypeQualifiedNames());
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public List<String> getStereotypesToApply() {
            return this.stereotypesToApply;
        }

        public void addStereotypeToApply(String qualifiedName) {
            this.stereotypesToApply.add(qualifiedName);
            this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, this.stereotypesToApply);
        }

        public void removeStereotypeToApply(String qualifiedName) {
            this.stereotypesToApply.remove(qualifiedName);
            this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, this.stereotypesToApply);
        }

        @Override
        public String getEditionDialogId() {
            return "";
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public Node generateNode(Document document) {
            Element node = document.createElement("appliedStereotypes");
            for (String qualifiedName : this.stereotypesToApply) {
                Element subNode = document.createElement("appliedStereotype");
                subNode.setAttribute("qualifiedName", qualifiedName);
                node.appendChild(subNode);
            }
            return node;
        }
    }
}

