/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.constraints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintParser {
    public static List<IConstraintDescriptor> parseConstraints(Node contextNode, Bundle bundle) {
        ArrayList<IConstraintDescriptor> constraintDescriptors = new ArrayList<IConstraintDescriptor>();
        NodeList children2 = contextNode.getChildNodes();
        Class elementClass = null;
        int j = 0;
        while (j < children2.getLength()) {
            Node child2 = children2.item(j);
            if ("elementClass".equals(child2.getNodeName())) {
                if (child2.getAttributes() != null && child2.getAttributes().getNamedItem("name") != null) {
                    String elementClassName = child2.getAttributes().getNamedItem("name").getNodeValue();
                    try {
                        elementClass = bundle.loadClass(elementClassName);
                        constraintDescriptors.add(new ObjectTypeConstraintDescriptor(elementClass));
                    }
                    catch (ClassNotFoundException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            } else if ("appliedStereotypes".equals(child2.getNodeName())) {
                ArrayList<String> appliedStereotypeQNames = new ArrayList<String>();
                NodeList stereotypeNodes = child2.getChildNodes();
                int i = 0;
                while (i < stereotypeNodes.getLength()) {
                    Node qualifiedName;
                    NamedNodeMap attributes;
                    Node stereotypeNode = stereotypeNodes.item(i);
                    String stereotypeNodeName = stereotypeNode.getNodeName();
                    if ("appliedStereotype".equals(stereotypeNodeName) && (attributes = stereotypeNode.getAttributes()) != null && (qualifiedName = attributes.getNamedItem("qualifiedName")) != null) {
                        appliedStereotypeQNames.add(qualifiedName.getNodeValue());
                    }
                    ++i;
                }
                constraintDescriptors.add(new AppliedStereotypeConstraintDescriptor(appliedStereotypeQNames));
            }
            ++j;
        }
        return constraintDescriptors;
    }
}

