/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.constraints;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConstraintDescriptor
implements IConstraintDescriptor,
IConfigurableDescriptor {
    protected final Class<?> elementClass;

    public ObjectTypeConstraintDescriptor(Class<?> elementClass) {
        this.elementClass = elementClass;
    }

    @Override
    public boolean select(Object objectToTest) {
        if (objectToTest == null) {
            return false;
        }
        return this.elementClass.isAssignableFrom(objectToTest.getClass());
    }

    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public String getText() {
        return "Object Type Constraint: " + this.getElementClass().getCanonicalName();
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/ObjectTypeConstraint.gif");
    }

    @Override
    public ConstraintDescriptorState createState(boolean readOnly) {
        return new ObjectTypeConstraintDescriptorState(this, readOnly);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ObjectTypeConstraintDescriptorState
    extends ConstraintDescriptorState {
        private PropertyChangeSupport changeSupport;
        private Class<?> elementClassState;

        public ObjectTypeConstraintDescriptorState(ObjectTypeConstraintDescriptor objectTypeConstraintDescriptor2, boolean readOnly) {
            super(objectTypeConstraintDescriptor2, readOnly);
            this.elementClassState = objectTypeConstraintDescriptor2.getElementClass();
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public void setElementClass(Class<?> elementClass) {
            Class<?> oldClass = this.elementClassState;
            this.elementClassState = elementClass;
            this.changeSupport.firePropertyChange("elementClass", oldClass, this.elementClassState);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public Node generateNode(Document document) {
            Element node = document.createElement("elementClass");
            node.setAttribute("name", this.elementClassState.getName());
            return node;
        }

        public Class<?> getElementClassState() {
            return this.elementClassState;
        }
    }
}

