/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewService;
import org.eclipse.papyrus.properties.runtime.view.content.AbstractContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDescriptor
extends AbstractContainerDescriptor {
    protected Composite describedComposite;
    protected List<PropertyEditorController> controllers = new ArrayList<PropertyEditorController>();
    protected List<Object> objectsToEdit;
    protected boolean unparsedContent = true;
    protected boolean parseFailed;
    protected List<IPropertyEditorControllerDescriptor> uncachedDescriptors;

    public ContainerDescriptor(LayoutDescriptor layoutDescriptor, Node containerNode) {
        super(layoutDescriptor, containerNode);
    }

    public ContainerDescriptor(LayoutDescriptor layoutDescriptor, List<IPropertyEditorControllerDescriptor> descriptors) {
        super(layoutDescriptor, null);
        this.uncachedDescriptors = descriptors;
        this.unparsedContent = false;
    }

    public Composite getDescribedComposite() {
        return this.describedComposite;
    }

    public void setDescribedComposite(Composite describedComposite) {
        this.describedComposite = describedComposite;
    }

    @Override
    public List<PropertyEditorController> createContent(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, List<Object> objectsToEdit) {
        this.objectsToEdit = objectsToEdit;
        if (this.getDescribedComposite() == null || this.getDescribedComposite().isDisposed()) {
            this.setDescribedComposite(widgetFactory.createComposite(parent));
            this.getDescribedComposite().setLayout(this.getLayoutDescriptor().createLayout());
            this.getDescribedComposite().setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.controllers = this.updateControllers(widgetFactory);
        return this.controllers;
    }

    protected Composite getPropertyEditorContainer() {
        return this.getDescribedComposite();
    }

    protected List<PropertyEditorController> updateControllers(TabbedPropertySheetWidgetFactory widgetFactory) {
        for (PropertyEditorController controller : this.controllers) {
            controller.dispose();
        }
        this.controllers.clear();
        if (this.unparsedContent) {
            this.uncachedDescriptors = new ArrayList<IPropertyEditorControllerDescriptor>();
            this.parseContent();
        }
        if (!this.parseFailed) {
            for (IPropertyEditorControllerDescriptor descriptor : this.getControllerDescriptors()) {
                this.controllers.add(PropertyViewService.getInstance().createPropertyEditorController(this.objectsToEdit, this.getPropertyEditorContainer(), descriptor, widgetFactory));
            }
        }
        return this.controllers;
    }

    public void dispose() {
        for (PropertyEditorController controller : this.controllers) {
            if (controller == null) continue;
            controller.dispose();
        }
        this.controllers.clear();
        if (this.getDescribedComposite() != null && !this.getDescribedComposite().isDisposed()) {
            this.getDescribedComposite().dispose();
        }
    }

    protected void parseContent() {
        NodeList children = this.containerNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("controller".equals(child.getNodeName())) {
                this.parseControllerNode(child);
            }
            ++i;
        }
    }

    protected void parseControllerNode(Node controllerNode) {
        if (!controllerNode.hasAttributes()) {
            Activator.log.error("impossible to find attributes for node " + controllerNode, null);
            return;
        }
        IPropertyEditorControllerDescriptor controllerDescriptor = null;
        Node predefinedIDNode = controllerNode.getAttributes().getNamedItem("predefinedId");
        if (predefinedIDNode != null) {
            controllerDescriptor = PropertyEditorControllerService.getInstance().createPredefinedControllerDescriptor(predefinedIDNode.getNodeValue());
        } else {
            String controllerId = controllerNode.getAttributes().getNamedItem("id").getNodeValue();
            controllerDescriptor = PropertyEditorControllerService.getInstance().createPropertyEditorControllerDescriptor(controllerId, controllerNode, null);
        }
        if (controllerDescriptor != null) {
            this.uncachedDescriptors.add(controllerDescriptor);
        }
    }

    @Override
    public List<IPropertyEditorControllerDescriptor> getControllerDescriptors() {
        return this.uncachedDescriptors;
    }

    public List<IPropertyEditorControllerDescriptor> getUnparsedControllerDescriptors() {
        if (this.unparsedContent) {
            this.uncachedDescriptors = new ArrayList<IPropertyEditorControllerDescriptor>();
            this.parseContent();
        }
        return this.getControllerDescriptors();
    }

    @Override
    public String getText() {
        return "SimpleContainerDescriptor";
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/Container.gif");
    }

    @Override
    public ContainerDescriptorState createState(boolean readOnly) {
        return new ContainerDescriptorState(this, readOnly);
    }
}

