/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.view.content.AbstractContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptorState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDescriptorState
extends AbstractState {
    protected AbstractContainerDescriptor descriptor;
    protected final List<ControllerDescriptorState> controllerDescriptorStates = new ArrayList<ControllerDescriptorState>();
    private PropertyChangeSupport changeSupport;
    protected final LayoutDescriptorState layoutDescriptorState;

    public ContainerDescriptorState(ContainerDescriptor descriptor, boolean readOnly) {
        super(readOnly);
        this.descriptor = descriptor;
        this.layoutDescriptorState = descriptor.getLayoutDescriptor().createState(readOnly);
        List<IPropertyEditorControllerDescriptor> controllerDescriptors = descriptor.getUnparsedControllerDescriptors();
        for (IPropertyEditorControllerDescriptor controllerDescriptor : controllerDescriptors) {
            this.controllerDescriptorStates.add(controllerDescriptor.createState(readOnly));
        }
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public AbstractContainerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<ControllerDescriptorState> getControllerDescriptorStates() {
        return this.controllerDescriptorStates;
    }

    public LayoutDescriptorState getLayoutDescriptorState() {
        return this.layoutDescriptorState;
    }

    @Override
    public String getEditionDialogId() {
        return "ContainerDescriptorStateDialog";
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyEditorControllerState(ControllerDescriptorState state) {
        this.controllerDescriptorStates.add(state);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, this.controllerDescriptorStates);
    }

    public void removePropertyEditorControllerState(ControllerDescriptorState state) {
        this.controllerDescriptorStates.remove(state);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, this.controllerDescriptorStates);
    }

    public List<AbstractState> getChildren() {
        ArrayList<AbstractState> states = new ArrayList<AbstractState>();
        states.add(this.layoutDescriptorState);
        states.addAll(this.getControllerDescriptorStates());
        return states;
    }

    @Override
    public Node generateNode(Document document) {
        Element node = document.createElement("container");
        this.generateLayoutDescriptor(node, document);
        this.generateControllers(node, document);
        return node;
    }

    protected void generateLayoutDescriptor(Element node, Document document) {
        node.appendChild(this.getLayoutDescriptorState().generateNode(document));
    }

    protected void generateControllers(Element node, Document document) {
        for (ControllerDescriptorState state : this.getControllerDescriptorStates()) {
            node.appendChild(state.generateNode(document));
        }
    }

    public Composite createPreview(Composite parent) {
        Composite composite = new TabbedPropertySheetWidgetFactory().createComposite(parent, 0);
        composite.setLayout(this.layoutDescriptorState.createLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        for (ControllerDescriptorState controllerDescriptorState : this.controllerDescriptorStates) {
            controllerDescriptorState.createPreview(composite);
        }
        return composite;
    }
}

