/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandableContainerDescriptor
extends ContainerDescriptor {
    private final String label;
    protected Composite expandableContainer;

    public ExpandableContainerDescriptor(LayoutDescriptor layoutDescriptor, String label, Node containerNode) {
        super(layoutDescriptor, containerNode);
        this.label = label;
    }

    public ExpandableContainerDescriptor(LayoutDescriptor layoutDescriptor, String label, List<IPropertyEditorControllerDescriptor> descriptors) {
        super(layoutDescriptor, descriptors);
        this.label = label;
    }

    public ExpandableComposite getDescribedComposite() {
        return (ExpandableComposite)super.getDescribedComposite();
    }

    @Override
    public List<PropertyEditorController> createContent(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, List<Object> objectsToEdit) {
        this.objectsToEdit = objectsToEdit;
        if (this.getDescribedComposite() == null || this.getDescribedComposite().isDisposed()) {
            this.setDescribedComposite((Composite)widgetFactory.createSection(parent, 322));
            this.getDescribedComposite().setLayoutData((Object)new GridData(4, 4, true, false));
            this.expandableContainer = widgetFactory.createComposite((Composite)this.getDescribedComposite());
            this.expandableContainer.setLayout(this.getLayoutDescriptor().createLayout());
            this.getDescribedComposite().setText(this.getLabel());
            widgetFactory.paintBordersFor(this.expandableContainer);
            this.getDescribedComposite().setClient((Control)this.expandableContainer);
        }
        this.controllers = this.updateControllers(widgetFactory);
        return this.controllers;
    }

    @Override
    protected Composite getPropertyEditorContainer() {
        return this.expandableContainer;
    }

    @Override
    public String getText() {
        return "ExpandableContainerDescriptor";
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/ExpandableContainer.gif");
    }

    @Override
    public ContainerDescriptorState createState(boolean readOnly) {
        return new ExpandableContainerDescriptorState(this, readOnly);
    }

    public String getLabel() {
        return this.label;
    }

    public class ExpandableContainerDescriptorState
    extends ContainerDescriptorState {
        private String name;
        private PropertyChangeSupport changeSupport;

        public ExpandableContainerDescriptorState(ExpandableContainerDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.name = descriptor.getLabel();
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public void setName(String name) {
            String oldName = this.name;
            this.name = name;
            this.changeSupport.firePropertyChange("name", oldName, this.name);
        }

        public String getName() {
            return this.name;
        }

        public Node generateNode(Document document) {
            Element node = document.createElement("expandableContainer");
            node.setAttribute("label", this.getName());
            this.generateLayoutDescriptor(node, document);
            this.generateControllers(node, document);
            return node;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            super.addPropertyChangeListener(listener);
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            super.removePropertyChangeListener(listener);
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public String getEditionDialogId() {
            return "ExpandableContainerDescriptorStateDialog";
        }

        public Composite createPreview(Composite parent) {
            Group composite = new TabbedPropertySheetWidgetFactory().createGroup(parent, "Expandable > " + this.name);
            composite.setLayout(this.layoutDescriptorState.createLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, false));
            for (ControllerDescriptorState controllerDescriptorState : this.controllerDescriptorStates) {
                controllerDescriptorState.createPreview((Composite)composite);
            }
            return composite;
        }

        public String getText() {
            return "Expandable \"" + this.getName() + "\"";
        }
    }
}

