/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.papyrus.properties.runtime.view.content.GridLayoutDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptorState;
import org.eclipse.swt.layout.GridLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GridLayoutDescriptorState
extends LayoutDescriptorState {
    private PropertyChangeSupport changeSupport;
    private int numColumns;
    private boolean sameWidth;

    public GridLayoutDescriptorState(GridLayoutDescriptor layoutDescriptor, boolean readOnly) {
        super(layoutDescriptor, readOnly);
        this.sameWidth = layoutDescriptor.isSameWidth();
        this.numColumns = layoutDescriptor.getNumColumns();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public GridLayoutDescriptor getDescriptor() {
        return (GridLayoutDescriptor)super.getDescriptor();
    }

    public String getEditionDialogId() {
        return "GridLayoutDescriptorStateDialog";
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.changeSupport.firePropertyChange("numColumns", this.numColumns, this.numColumns);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setSameWidth(boolean sameWidth) {
        this.sameWidth = sameWidth;
        this.changeSupport.firePropertyChange("sameWidth", this.sameWidth, this.sameWidth);
    }

    public boolean getSameWidth() {
        return this.sameWidth;
    }

    public Node generateNode(Document document) {
        Element node = document.createElement("layout");
        node.setAttribute("kind", "Grid");
        node.setAttribute("numColumns", "" + this.getNumColumns());
        node.setAttribute("sameWidth", "" + this.getSameWidth());
        return node;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GridLayout (");
        buffer.append(this.getNumColumns());
        buffer.append(", ");
        buffer.append(this.getSameWidth());
        buffer.append(")");
        return buffer.toString();
    }

    public GridLayout createLayout() {
        return new GridLayout(this.numColumns, this.sameWidth);
    }
}

