/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.ContainerDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupContainerDescriptor
extends ContainerDescriptor {
    protected final String label;

    public GroupContainerDescriptor(LayoutDescriptor layoutDescriptor, String label, Node containerNode) {
        super(layoutDescriptor, containerNode);
        this.label = label;
    }

    public GroupContainerDescriptor(LayoutDescriptor layoutDescriptor, String label, List<IPropertyEditorControllerDescriptor> descriptors) {
        super(layoutDescriptor, descriptors);
        this.label = label;
    }

    public Group getDescribedComposite() {
        return (Group)super.getDescribedComposite();
    }

    @Override
    public List<PropertyEditorController> createContent(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, List<Object> objectsToEdit) {
        this.objectsToEdit = objectsToEdit;
        if (this.getDescribedComposite() == null || this.getDescribedComposite().isDisposed()) {
            this.setDescribedComposite((Composite)widgetFactory.createGroup(parent, this.label));
            this.getDescribedComposite().setText(this.label);
            this.getDescribedComposite().setLayout(this.getLayoutDescriptor().createLayout());
            this.getDescribedComposite().setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.controllers = this.updateControllers(widgetFactory);
        return this.controllers;
    }

    @Override
    public String getText() {
        return "GroupContainerDescriptor";
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/GroupContainer.gif");
    }

    @Override
    public ContainerDescriptorState createState(boolean readOnly) {
        return new GroupContainerDescriptorState(this, readOnly);
    }

    public String getLabel() {
        return this.label;
    }

    public class GroupContainerDescriptorState
    extends ContainerDescriptorState {
        private String name;
        private PropertyChangeSupport changeSupport;

        public GroupContainerDescriptorState(GroupContainerDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.name = descriptor.getLabel();
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            super.addPropertyChangeListener(listener);
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            super.removePropertyChangeListener(listener);
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public void setName(String name) {
            String oldName = this.name;
            this.name = name;
            this.changeSupport.firePropertyChange("label", oldName, this.name);
        }

        public String getText() {
            return "Group \"" + this.getName() + "\"";
        }

        public String getName() {
            return this.name;
        }

        public Node generateNode(Document document) {
            Element node = document.createElement("groupContainer");
            node.setAttribute("label", this.getName());
            this.generateLayoutDescriptor(node, document);
            this.generateControllers(node, document);
            return node;
        }

        public String getEditionDialogId() {
            return "GroupContainerDescriptorStateDialog";
        }

        public Composite createPreview(Composite parent) {
            Group composite = new TabbedPropertySheetWidgetFactory().createGroup(parent, this.name);
            composite.setLayout(this.layoutDescriptorState.createLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, false));
            for (ControllerDescriptorState controllerDescriptorState : this.controllerDescriptorStates) {
                controllerDescriptorState.createPreview((Composite)composite);
            }
            return composite;
        }
    }
}

