/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.view.content;

import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.content.GridLayoutDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.LayoutDescriptor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LayoutParser {
    public static final String GRID_KIND = "Grid";

    public static LayoutDescriptor parseLayoutNode(Node layoutNode) {
        if (layoutNode == null) {
            return new GridLayoutDescriptor();
        }
        String type = LayoutParser.getType(layoutNode);
        if (GRID_KIND.equals(type)) {
            NamedNodeMap attributes = layoutNode.getAttributes();
            if (attributes == null) {
                Activator.log.warn("Impossible to parse the attribute set for grid layout: " + layoutNode);
                return new GridLayoutDescriptor();
            }
            int numColumns = 2;
            Node numColumnsNode = attributes.getNamedItem("numColumns");
            if (numColumnsNode != null) {
                try {
                    numColumns = Integer.parseInt(numColumnsNode.getNodeValue());
                }
                catch (NumberFormatException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            boolean sameWidth = true;
            Node sameWidthNode = attributes.getNamedItem("sameWidth");
            if (sameWidthNode != null) {
                sameWidth = Boolean.parseBoolean(sameWidthNode.getNodeValue());
            }
            return new GridLayoutDescriptor(numColumns, sameWidth);
        }
        return new GridLayoutDescriptor();
    }

    private static String getType(Node layoutNode) {
        NamedNodeMap attributes = layoutNode.getAttributes();
        if (attributes == null) {
            Activator.log.warn("Impossible to parse the attribute set for layout node: " + layoutNode);
            return GRID_KIND;
        }
        Node kindNode = attributes.getNamedItem("kind");
        if (kindNode == null) {
            Activator.log.warn("Impossible to find the kind attribute for the layout node: " + layoutNode);
            return GRID_KIND;
        }
        return kindNode.getNodeValue();
    }
}

