/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Camille Letavernier (CEA LIST) camille.letavernier@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.properties.widgets;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Composite;

/**
 * A Property Editor for editing a String with an editable combo.
 * The combo proposes a set of default values.
 * 
 * @author Camille Letavernier
 */
public class StringCombo extends AbstractPropertyEditor {

	/**
	 * The StringCombo widget used by this property editor
	 */
	protected org.eclipse.papyrus.widgets.editors.StringCombo editor;

	/**
	 * 
	 * Constructor.
	 * 
	 * @param parent
	 * @param style
	 */
	public StringCombo(Composite parent, int style) {
		editor = new org.eclipse.papyrus.widgets.editors.StringCombo(parent, style);
		super.setEditor(editor);
	}

	@Override
	public void doBinding() {
		IStaticContentProvider contentProvider = input.getContentProvider(propertyPath);
		editor.setContentProvider(contentProvider);
		editor.setUnsettable(!input.isMandatory(propertyPath));

		ILabelProvider labelProvider = input.getLabelProvider(propertyPath);
		if(labelProvider != null) {
			editor.setLabelProvider(labelProvider);
		}
		super.doBinding();
	}
}
