/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.PropertyServiceUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class XMLBasedTabDescriptorProvider
implements ITabDescriptorProvider,
IEclipsePreferences.IPreferenceChangeListener {
    protected ITabDescriptor[] descriptors = null;

    public XMLBasedTabDescriptorProvider() {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.papyrus.properties.runtime");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (this.descriptors == null && part instanceof CoreMultiDiagramEditor && selection != null) {
            ArrayList<ITabDescriptor> descriptors = new ArrayList<ITabDescriptor>();
            List<List<ITabDescriptor>> list = PropertyServiceUtil.getTabDescriptors();
            for (List<ITabDescriptor> sub : list) {
                descriptors.addAll(sub);
            }
            TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry((ITabbedPropertySheetPageContributor)((CoreMultiDiagramEditor)part));
            try {
                Method method = TabbedPropertyRegistry.class.getDeclaredMethod("getAllTabDescriptors", new Class[0]);
                method.setAccessible(true);
                ITabDescriptor[] registeredTabDesriptors = (ITabDescriptor[])method.invoke((Object)registry, new Object[0]);
                if (registeredTabDesriptors != null) {
                    descriptors.addAll(Arrays.asList(registeredTabDesriptors));
                }
            }
            catch (IllegalArgumentException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Activator.log.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Activator.log.error((Throwable)e);
            }
            catch (SecurityException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                Activator.log.error((Throwable)e);
            }
            for (ITabDescriptor descriptor : descriptors) {
                this.orderSectionInTabDescriptor(descriptor);
            }
            this.descriptors = descriptors.toArray(new ITabDescriptor[descriptors.size()]);
        }
        return this.descriptors != null ? this.descriptors : new ITabDescriptor[]{};
    }

    protected void orderSectionInTabDescriptor(ITabDescriptor tabDescriptor) {
        HashMap<String, ISectionDescriptor> map = new HashMap<String, ISectionDescriptor>();
        for (ISectionDescriptor descriptor : tabDescriptor.getSectionDescriptors()) {
            map.put(descriptor.getId(), descriptor);
        }
        Collections.sort(tabDescriptor.getSectionDescriptors(), new Comparator<ISectionDescriptor>(){

            @Override
            public int compare(ISectionDescriptor section0, ISectionDescriptor section1) {
                int delta = 0;
                ISectionDescriptor previousSection0 = this.getPreviousSection(section0);
                while (previousSection0 != null) {
                    ++delta;
                    if (section1.equals(previousSection0)) {
                        return delta;
                    }
                    previousSection0 = this.getPreviousSection(previousSection0);
                }
                delta = 0;
                ISectionDescriptor previousSection1 = this.getPreviousSection(section1);
                while (previousSection1 != null) {
                    --delta;
                    if (section0.equals(previousSection1)) {
                        return delta;
                    }
                    previousSection1 = this.getPreviousSection(previousSection1);
                }
                return 0;
            }

            public ISectionDescriptor getPreviousSection(ISectionDescriptor section) {
                String afterId = section.getAfterSection();
                if (afterId == "top") {
                    return null;
                }
                return (ISectionDescriptor)map.get(afterId);
            }
        });
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("propertyViewCustomizations".equals(event.getKey())) {
            this.descriptors = null;
        }
    }
}

