/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.AbstractContainerDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSection
extends AbstractPropertySection {
    public static final String SEMANTIC_RESOLVER = "Semantic";
    public static final String GRAPHIC_RESOLVER = "Graphic";
    public static final String EDIT_PART_RESOLVER = "EditPart";
    protected Composite parent;
    protected List<Object> objectsToEdit;
    protected final List<AbstractContainerDescriptor> containers;
    protected TabbedPropertySheetPage tabbedPropertySheetPage;
    protected List<IFragmentDescriptor> fragmentDescriptors;
    protected final String adapterId;

    public DynamicSection(List<IFragmentDescriptor> fragmentDescriptors, String adapterId) {
        this.fragmentDescriptors = fragmentDescriptors;
        this.containers = new ArrayList<AbstractContainerDescriptor>();
        this.adapterId = adapterId;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.tabbedPropertySheetPage = tabbedPropertySheetPage;
        this.parent = tabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        GridData data = new GridData(1808);
        this.parent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parent.setLayout((Layout)layout);
    }

    public void dispose() {
        for (AbstractContainerDescriptor container : this.containers) {
            container.dispose();
            Object var1_2 = null;
        }
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ArrayList<Object> newObjects = new ArrayList<Object>();
        Iterator it = ((IStructuredSelection)selection).iterator();
        while (it.hasNext()) {
            Object newObject = this.getAdaptedObject(it.next());
            if (newObject == null) continue;
            newObjects.add(newObject);
        }
        this.refreshDisplay(newObjects);
        this.parent.layout(false, true);
    }

    public Object getAdaptedObject(Object objectToAdapt) {
        if (SEMANTIC_RESOLVER.equals(this.adapterId)) {
            return this.resolveSemanticElement(objectToAdapt);
        }
        if (GRAPHIC_RESOLVER.equals(this.adapterId)) {
            return this.resolveGraphicElement(objectToAdapt);
        }
        if (EDIT_PART_RESOLVER.equals(this.adapterId)) {
            return this.resolveEditPart(objectToAdapt);
        }
        return objectToAdapt;
    }

    protected EObject resolveSemanticElement(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof EObject) {
            return (EObject)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }

    protected EditPart resolveEditPart(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof EditPart) {
            return (EditPart)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(EditPart.class) != null) {
            return (EditPart)adaptable.getAdapter(EditPart.class);
        }
        return null;
    }

    protected View resolveGraphicElement(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof View) {
            return (View)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(View.class) != null) {
            return (View)adaptable.getAdapter(View.class);
        }
        return null;
    }

    protected void refreshDisplay(List<Object> newObjects) {
        if (!newObjects.isEmpty() && !newObjects.equals(this.objectsToEdit)) {
            this.objectsToEdit = newObjects;
            for (AbstractContainerDescriptor container : this.containers) {
                container.dispose();
            }
            this.containers.clear();
            for (IFragmentDescriptor viewDescriptor : this.fragmentDescriptors) {
                for (AbstractContainerDescriptor descriptor : viewDescriptor.getContainerDescriptors()) {
                    descriptor.createContent(this.parent, this.tabbedPropertySheetPage.getWidgetFactory(), this.objectsToEdit);
                    this.containers.add(descriptor);
                }
            }
        }
    }
}

