/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSection;
import org.eclipse.papyrus.properties.tabbed.core.view.IEnhancedFilter;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDispatcher;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSectionDescriptor
extends AbstractSectionDescriptor
implements IEnhancedFilter,
IConfigurableDescriptor {
    public static final String SEMANTIC_RESOLVER = "Semantic";
    public static final String GRAPHIC_RESOLVER = "Graphic";
    public static final String EDIT_PART_RESOLVER = "EditPart";
    protected ISection section;
    protected final String id;
    protected final String tabId;
    protected Node unparsedSectionNode;
    protected boolean unparsed = true;
    protected boolean parseSectionFailed = false;
    protected final List<IConstraintDescriptor> constraints;
    protected final int selectionSize;
    protected final String adapterId;
    protected final List<String> replacedSectionIds;
    protected final String afterSectionId;
    protected final List<IFragmentDescriptor> fragmentDescriptors;

    public DynamicSectionDescriptor(String id, String tabId, List<IConstraintDescriptor> constraints, int selectionSize, String adapterID, List<String> replacedSectionIds, String afterSectionId, List<IFragmentDescriptor> fragmentDescriptors) {
        this.id = id;
        this.tabId = tabId;
        this.constraints = constraints;
        this.selectionSize = selectionSize;
        this.adapterId = adapterID;
        this.replacedSectionIds = replacedSectionIds;
        this.afterSectionId = afterSectionId;
        this.fragmentDescriptors = fragmentDescriptors;
    }

    public int getEnablesFor() {
        return this.selectionSize;
    }

    public String getId() {
        return this.id;
    }

    public String getAfterSection() {
        if (this.afterSectionId == null) {
            return super.getAfterSection();
        }
        return this.afterSectionId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public ISection getSectionClass() {
        return new DynamicSection(this.fragmentDescriptors, this.getAdapterId());
    }

    public String getTargetTab() {
        return this.tabId;
    }

    public void setUnparsedContent(Node sectionNode) {
        this.unparsedSectionNode = sectionNode;
    }

    public IEnhancedFilter getFilter() {
        return this;
    }

    public boolean select(Object toTest) {
        return SectionDispatcher.getInstance().isSectionDisplayed(this, toTest);
    }

    public boolean appliesTo(IWorkbenchPart part, ISelection selection) {
        List<DynamicSectionDescriptor> filteredDescriptors = SectionDispatcher.getInstance().getDisplayedSections(part, selection);
        return filteredDescriptors.contains(this);
    }

    public boolean appliesToWithoutSectionInheritance(IWorkbenchPart part, ISelection selection) {
        return super.appliesTo(part, selection);
    }

    public List<IConstraintDescriptor> getConstraints() {
        return this.constraints;
    }

    public Object getAdaptedObject(Object objectToAdapt) {
        if (SEMANTIC_RESOLVER.equals(this.adapterId)) {
            return this.resolveSemanticElement(objectToAdapt);
        }
        if (GRAPHIC_RESOLVER.equals(this.adapterId)) {
            return this.resolveGraphicElement(objectToAdapt);
        }
        if (EDIT_PART_RESOLVER.equals(this.adapterId)) {
            return this.resolveEditPart(objectToAdapt);
        }
        return objectToAdapt;
    }

    protected EObject resolveSemanticElement(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof EObject) {
            return (EObject)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }

    protected EditPart resolveEditPart(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof EditPart) {
            return (EditPart)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(EditPart.class) != null) {
            return (EditPart)adaptable.getAdapter(EditPart.class);
        }
        return null;
    }

    protected View resolveGraphicElement(Object objectToAdapt) {
        IAdaptable adaptable;
        if (objectToAdapt instanceof View) {
            return (View)objectToAdapt;
        }
        if (objectToAdapt instanceof IAdaptable && (adaptable = (IAdaptable)objectToAdapt).getAdapter(View.class) != null) {
            return (View)adaptable.getAdapter(View.class);
        }
        return null;
    }

    @Override
    public boolean selectWithoutVisibility(Object objectToTest) {
        List<IConstraintDescriptor> constraintDescriptors = this.getConstraints();
        if (constraintDescriptors == null || constraintDescriptors.isEmpty()) {
            org.eclipse.papyrus.properties.runtime.Activator.log.warn("No constraints found for descriptor : " + this.getText());
            return false;
        }
        Object adaptedObject = this.getAdaptedObject(objectToTest);
        for (IConstraintDescriptor constraintDescriptor : constraintDescriptors) {
            if (constraintDescriptor.select(adaptedObject)) continue;
            return false;
        }
        return true;
    }

    public List<String> getReplacedSectionIds() {
        return this.replacedSectionIds;
    }

    public String getText() {
        return "Section: " + this.getId() + " in tab: " + this.getTargetTab();
    }

    public Image getImage() {
        return Activator.getImage("/icons/Section.gif");
    }

    public SectionDescriptorState createState(boolean readOnly) {
        return new SectionDescriptorState(this, readOnly);
    }

    public List<IFragmentDescriptor> getFragmentDescriptors() {
        return this.fragmentDescriptors;
    }
}

