/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.FragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PredefinedFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewProviderParser;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicTabDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.DynamicSubFeatureSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.EMFSimpleSubFeatureDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.ExpandableContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.GroupContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SimpleContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTabViewProviderParser
extends PropertyViewProviderParser {
    protected static final Object NODE_NAME_PROPERTY_TAB_VIEW = "propertyTabView";
    protected static final String ID = "id";
    protected static final String CATEGORY = "category";
    protected static final String LABEL = "label";
    protected static final String TAB_ID = "tabId";
    protected static final String ADAPTER_ID = "adapterId";
    protected static final String NODE_NAME_SECTION = "section";
    protected static final String NODE_NAME_SECTION_SET = "sectionSet";
    protected static final String NODE_NAME_TAB = "tab";
    protected static final String NODE_NAME_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String NODE_NAME_SECTION_SUBFEATURE = "subFeatureSection";
    protected static final String AFTER_SECTION_ID = "afterSection";
    protected List<ITabDescriptor> tabDescriptors;
    protected List<ITabDescriptor> providedTabDescriptors = new ArrayList<ITabDescriptor>();
    private List<SectionSetDescriptor> providedSectionSets = new ArrayList<SectionSetDescriptor>();

    public PropertyTabViewProviderParser(List<ITabDescriptor> tabDescriptors) {
        this.tabDescriptors = tabDescriptors;
    }

    public void parseXMLfile(Document document, Map<String, FragmentDescriptor> predefinedFragments, Map<String, DialogDescriptor> predefinedDialogs) throws XMLParseException {
        this.predefinedFragments = predefinedFragments;
        this.predefinedDialogs = predefinedDialogs;
        NodeList views = document.getChildNodes();
        int i = 0;
        while (i < views.getLength()) {
            Node propertyViewNode = views.item(i);
            if (NODE_NAME_PROPERTY_TAB_VIEW.equals(propertyViewNode.getNodeName())) {
                this.parsePropertyTabViewNode(propertyViewNode);
            }
            ++i;
        }
    }

    protected void parsePropertyTabViewNode(Node propertyViewNode) throws XMLParseException {
        String pluginId = this.getPluginIdFromTopNode(propertyViewNode);
        this.bundle = Platform.getBundle((String)pluginId);
        NodeList children = propertyViewNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getNodeName();
            if (NODE_NAME_SECTION_SET.equals(childNodeName)) {
                this.getProvidedSectionSets().add(this.parseSectionSetNode(childNode));
            } else if (NODE_NAME_TAB.equals(childNodeName)) {
                DynamicTabDescriptor tabDescriptor = this.parseTab(childNode);
                this.providedTabDescriptors.add((ITabDescriptor)tabDescriptor);
                this.tabDescriptors.add((ITabDescriptor)tabDescriptor);
            }
            ++i;
        }
    }

    protected DynamicTabDescriptor parseTab(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String id = null;
        String label = null;
        String category = null;
        Node childNode = attributes.getNamedItem("id");
        if (childNode != null) {
            id = childNode.getNodeValue();
        } else {
            Activator.log.error("impossible to parse id for the tab using " + node, null);
        }
        childNode = attributes.getNamedItem(CATEGORY);
        if (childNode != null) {
            category = childNode.getNodeValue();
        } else {
            Activator.log.error("impossible to parse category for the tab using " + node, null);
        }
        childNode = attributes.getNamedItem(LABEL);
        if (childNode != null) {
            label = childNode.getNodeValue();
        } else {
            Activator.log.error("impossible to parse label for the tab using " + node, null);
        }
        if (label != null && id != null && category != null) {
            DynamicTabDescriptor tabDescriptor = new DynamicTabDescriptor(category, id, label);
            return tabDescriptor;
        }
        return null;
    }

    protected SectionSetDescriptor parseSectionSetNode(Node sectionSetNode) {
        Node node;
        ArrayList<DynamicSectionDescriptor> sectionDescriptors = new ArrayList<DynamicSectionDescriptor>();
        ArrayList<IConstraintDescriptor> constraintDescriptors = new ArrayList<IConstraintDescriptor>();
        int selectionSize = 0;
        NamedNodeMap attributes = sectionSetNode.getAttributes();
        String name = null;
        if (attributes != null && (node = attributes.getNamedItem(ATTRIBUTE_NAME)) != null) {
            name = node.getNodeValue();
        }
        NodeList children = sectionSetNode.getChildNodes();
        Node contextNode = null;
        ArrayList<Node> sectionNodes = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if ("context".equals(nodeName)) {
                contextNode = child;
            } else if (NODE_NAME_SECTION.equals(nodeName) || NODE_NAME_SECTION_SUBFEATURE.equals(nodeName)) {
                sectionNodes.add(child);
            }
            ++i;
        }
        if (contextNode == null || sectionNodes.isEmpty()) {
            Activator.log.error("impossible to find a context node or a list of sections for section set " + name, null);
            return null;
        }
        List constraintDescriptors2 = this.parseConstraints(contextNode);
        assert (constraintDescriptors2 != null && !constraintDescriptors2.isEmpty()) : "constraints should not be null...";
        constraintDescriptors.addAll(constraintDescriptors2);
        selectionSize = this.parseSelectionSize(contextNode);
        for (Node sectionNode : sectionNodes) {
            DynamicSectionDescriptor sectionDescriptor = this.parseSectionNode(sectionNode, constraintDescriptors, selectionSize);
            sectionDescriptors.add(sectionDescriptor);
        }
        return new SectionSetDescriptor(name, sectionDescriptors, constraintDescriptors, selectionSize);
    }

    protected DynamicSectionDescriptor parseSectionNode(Node sectionNode, List<IConstraintDescriptor> constraints, int selectionSize) {
        String nodeName = sectionNode.getNodeName();
        boolean isSubFeatureSection = false;
        if (nodeName.equals(NODE_NAME_SECTION_SUBFEATURE)) {
            isSubFeatureSection = true;
        }
        NamedNodeMap attributes = sectionNode.getAttributes();
        String id = null;
        String tabId = null;
        String adapterId = null;
        String afterSection = null;
        if (attributes != null) {
            Node node = attributes.getNamedItem("id");
            if (node != null) {
                id = node.getNodeValue();
            }
            if ((node = attributes.getNamedItem(TAB_ID)) != null) {
                tabId = node.getNodeValue();
            }
            if ((node = attributes.getNamedItem(ADAPTER_ID)) != null) {
                adapterId = node.getNodeValue();
            }
            if ((node = attributes.getNamedItem(AFTER_SECTION_ID)) != null) {
                afterSection = node.getNodeValue();
            }
        }
        List<String> replacedSectionsId = new ArrayList<String>();
        ArrayList<IFragmentDescriptor> fragmentDescriptors = new ArrayList<IFragmentDescriptor>();
        try {
            NodeList children = sectionNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                IFragmentDescriptor fragmentDescriptor;
                Node childNode = children.item(i);
                if ("replacedSections".equals(childNode.getNodeName())) {
                    replacedSectionsId = this.parseReplacedSectionIds(childNode);
                } else if ("fragment".equals(childNode.getNodeName()) && (fragmentDescriptor = this.parseFragmentOrPredefinedFragment(childNode)) != null) {
                    fragmentDescriptors.add(fragmentDescriptor);
                }
                ++i;
            }
        }
        catch (XMLParseException e) {
            Activator.log.error("Problem during parsing of replaced sections for node " + sectionNode, (Throwable)e);
        }
        if (isSubFeatureSection) {
            Node node;
            int maxColumn = 2;
            if (attributes != null && (node = attributes.getNamedItem("maxColumn")) != null) {
                maxColumn = Integer.parseInt(node.getNodeValue());
            }
            NodeList children = sectionNode.getChildNodes();
            EMFSimpleSubFeatureDescriptor subFeatureDescriptor = null;
            SubFeatureContainerDescriptor subFeatureContainerDescriptor = null;
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if ("subFeatureDescriptor".equals(childNode.getNodeName())) {
                    String name = childNode.getAttributes().getNamedItem("featureName").getNodeValue();
                    subFeatureDescriptor = new EMFSimpleSubFeatureDescriptor(name);
                } else if ("subFeatureDescriptorContainer".equals(childNode.getNodeName())) {
                    subFeatureContainerDescriptor = this.parseSubFeatureContainerDescriptorNode(childNode);
                }
                ++i;
            }
            DynamicSubFeatureSectionDescriptor descriptor = new DynamicSubFeatureSectionDescriptor(id, tabId, constraints, selectionSize, adapterId, replacedSectionsId, afterSection, fragmentDescriptors, subFeatureDescriptor, maxColumn, subFeatureContainerDescriptor);
            descriptor.setUnparsedContent(sectionNode);
            for (ITabDescriptor tabDescriptor : this.tabDescriptors) {
                if (!tabDescriptor.getId().equals(tabId)) continue;
                tabDescriptor.getSectionDescriptors().add(descriptor);
                return descriptor;
            }
        } else {
            DynamicSectionDescriptor descriptor = new DynamicSectionDescriptor(id, tabId, constraints, selectionSize, adapterId, replacedSectionsId, afterSection, fragmentDescriptors);
            descriptor.setUnparsedContent(sectionNode);
            for (ITabDescriptor tabDescriptor : this.tabDescriptors) {
                if (!tabDescriptor.getId().equals(tabId)) continue;
                boolean contains = false;
                for (ISectionDescriptor dynamicSectionDescriptor : tabDescriptor.getSectionDescriptors()) {
                    String sectionId = dynamicSectionDescriptor.getId();
                    if (!id.equals(sectionId)) continue;
                    contains = true;
                }
                if (!contains) {
                    tabDescriptor.getSectionDescriptors().add(descriptor);
                }
                return descriptor;
            }
        }
        return null;
    }

    protected SubFeatureContainerDescriptor parseSubFeatureContainerDescriptorNode(Node descriptorNode) {
        String label;
        String type = "simpleContainer";
        NamedNodeMap attributes = descriptorNode.getAttributes();
        if (attributes != null) {
            Node typeNode = attributes.getNamedItem("type");
            if (typeNode != null) {
                type = typeNode.getNodeValue();
            }
        } else {
            return new SimpleContainerDescriptor();
        }
        if ("simpleContainer".equals(type)) {
            return new SimpleContainerDescriptor();
        }
        if ("groupContainer".equals(type)) {
            label = "";
            Node labelNode = attributes.getNamedItem(LABEL);
            if (labelNode != null) {
                label = labelNode.getNodeValue();
            }
            return new GroupContainerDescriptor(label);
        }
        if ("expandableContainer".equals(type)) {
            label = "";
            Node labelNode = attributes.getNamedItem(LABEL);
            if (labelNode != null) {
                label = labelNode.getNodeValue();
            }
            return new ExpandableContainerDescriptor(label);
        }
        return new SimpleContainerDescriptor();
    }

    protected IFragmentDescriptor parseFragmentOrPredefinedFragment(Node fragmentNode) {
        Node attribute;
        NamedNodeMap attributes = fragmentNode.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem("predefinedId")) != null) {
            return new PredefinedFragmentDescriptor(attribute.getNodeValue());
        }
        try {
            FragmentDescriptor fragmentDescriptor = this.parseFragment(fragmentNode);
            if (fragmentDescriptor != null) {
                this.predefinedFragments.put(fragmentDescriptor.getId(), fragmentDescriptor);
            }
            return fragmentDescriptor;
        }
        catch (XMLParseException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> parseReplacedSectionIds(Node replacedSectionsNode) throws XMLParseException {
        ArrayList<String> list = new ArrayList<String>();
        NodeList children = replacedSectionsNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("replacedSection".equals(child.getNodeName())) {
                NamedNodeMap attributes = child.getAttributes();
                if (attributes == null) throw new XMLParseException("impossible to find attributes in the replacedSection node " + child);
                Node idNode = attributes.getNamedItem("id");
                if (idNode == null) throw new XMLParseException("impossible to fin the id attribute in the replacedSection node " + child);
                list.add(idNode.getNodeValue());
            }
            ++i;
        }
        return list;
    }

    protected List<ITabDescriptor> getResult() {
        return this.tabDescriptors;
    }

    public List<SectionSetDescriptor> getProvidedSectionSets() {
        return this.providedSectionSets;
    }

    public List<ITabDescriptor> getProvidedTabDescriptors() {
        return this.providedTabDescriptors;
    }
}

