/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.IFragmentDescriptorState;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.StatesStore;
import org.eclipse.papyrus.properties.tabbed.core.view.TabDescriptorState;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionDescriptorState
extends AbstractState {
    protected DynamicSectionDescriptor sectionDescriptor;
    protected List<IFragmentDescriptorState> fragmentDescriptorStates = new ArrayList<IFragmentDescriptorState>();
    protected List<ReplacedSectionState> replacedSectionStates = new ArrayList<ReplacedSectionState>();
    protected PropertyChangeSupport changeSupport;
    protected String id;
    protected String targetTab;
    protected String adapterId;
    protected String afterSection;

    public SectionDescriptorState(DynamicSectionDescriptor sectionDescriptor, boolean readOnly) {
        super(readOnly);
        this.sectionDescriptor = sectionDescriptor;
        this.id = sectionDescriptor.getId();
        this.targetTab = sectionDescriptor.getTargetTab();
        this.adapterId = sectionDescriptor.getAdapterId();
        this.afterSection = sectionDescriptor.getAfterSection();
        List<String> replaceSections = sectionDescriptor.getReplacedSectionIds();
        for (String replacedSectionId : replaceSections) {
            this.getReplacedSectionStates().add(new ReplacedSectionState(replacedSectionId));
        }
        List<IFragmentDescriptor> fragmentDescriptors = sectionDescriptor.getFragmentDescriptors();
        for (IFragmentDescriptor fragmentDescriptor : fragmentDescriptors) {
            if (fragmentDescriptor == null) continue;
            this.getFragmentDescriptorStates().add(fragmentDescriptor.createState(readOnly));
        }
        this.changeSupport = new PropertyChangeSupport((Object)this);
    }

    public DynamicSectionDescriptor getDescriptor() {
        return this.sectionDescriptor;
    }

    public List<IFragmentDescriptorState> getFragmentDescriptorStates() {
        return this.fragmentDescriptorStates;
    }

    public String getEditionDialogId() {
        return "SectionDescriptorStateDialog";
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.changeSupport.firePropertyChange("id", oldId, id);
    }

    public String getId() {
        return this.id;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public List<String> getAvailableTargetTab() {
        ArrayList<String> result = new ArrayList<String>();
        List<TabDescriptorState> tabStates = StatesStore.getTabDescriptorStates();
        for (TabDescriptorState tabDescriptorState : tabStates) {
            result.add(tabDescriptorState.getId());
        }
        return result;
    }

    public List<String> getAvailableAfterSection() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("top");
        List<SectionSetDescriptorState> sectionSetDescriptorStates = StatesStore.getSectionSetDescriptorStates();
        for (SectionSetDescriptorState sectionSetDescriptorState : sectionSetDescriptorStates) {
            List<SectionDescriptorState> sectionDescriptorStates = sectionSetDescriptorState.getSectionDescriptorStates();
            for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
                result.add(sectionDescriptorState.getId());
            }
        }
        return result;
    }

    public void setAdapterId(String adapterId) {
        String oldId = this.adapterId;
        this.adapterId = adapterId;
        this.changeSupport.firePropertyChange("adapterId", oldId, adapterId);
    }

    public void setTargetTab(String targetTab) {
        String oldTargetTab = this.targetTab;
        this.targetTab = targetTab;
        this.changeSupport.firePropertyChange("targetTab", oldTargetTab, targetTab);
    }

    public String getTargetTab() {
        return this.targetTab;
    }

    public void setAfterSection(String afterSection) {
        this.afterSection = afterSection;
        this.changeSupport.firePropertyChange("afterSection", this.afterSection, this.afterSection);
    }

    public String getAfterSection() {
        return this.afterSection;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Section: ");
        buffer.append(this.getId());
        buffer.append(" in tab: ");
        buffer.append(this.getTargetTab());
        if (this.getAfterSection() != "top") {
            buffer.append(" after section: ");
            buffer.append(this.getAfterSection());
        } else {
            buffer.append(" (unordered)");
        }
        return buffer.toString();
    }

    public List<? extends ITraversableModelElement> getChildren() {
        ArrayList<ReplacedSectionState> children = new ArrayList<ReplacedSectionState>();
        children.addAll(this.getReplacedSectionStates());
        children.addAll(this.getFragmentDescriptorStates());
        return children;
    }

    public void addFragmentDescriptorState(IFragmentDescriptorState state) {
        this.fragmentDescriptorStates.add(state);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, state);
    }

    public void removeFragmentDescriptorState(IFragmentDescriptorState state) {
        this.fragmentDescriptorStates.remove(state);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, state);
    }

    public Node generateNode(Document document) {
        Element node = document.createElement("section");
        node.setAttribute("id", this.getId());
        node.setAttribute("tabId", this.getTargetTab());
        node.setAttribute("adapterId", this.getAdapterId());
        node.setAttribute("afterSection", this.getAfterSection());
        this.generateReplacedSectionStates(node, document);
        this.generateFragmentDescriptorStateNodes(node, document);
        return node;
    }

    protected void generateReplacedSectionStates(Element node, Document document) {
        if (this.getReplacedSectionStates() != null && !this.getReplacedSectionStates().isEmpty()) {
            Element root = document.createElement("replacedSections");
            for (ReplacedSectionState state : this.getReplacedSectionStates()) {
                root.appendChild(state.generateNode(document));
            }
            node.appendChild(root);
        }
    }

    protected void generateFragmentDescriptorStateNodes(Element node, Document document) {
        for (IFragmentDescriptorState fragmentDescriptorState : this.getFragmentDescriptorStates()) {
            node.appendChild(fragmentDescriptorState.generateNode(document));
        }
    }

    public List<ReplacedSectionState> getReplacedSectionStates() {
        return this.replacedSectionStates;
    }

    public void addReplacedSectionState(ReplacedSectionState id) {
        this.replacedSectionStates.add(id);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, this.replacedSectionStates);
    }

    public void removeReplacedSectionState(ReplacedSectionState id) {
        this.replacedSectionStates.remove(id);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, this.replacedSectionStates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReplacedSectionState
    implements IState,
    ITraversableModelElement {
        private String id;
        private PropertyChangeSupport changeSupport;

        public ReplacedSectionState(String id) {
            this.id = id;
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public String getText() {
            return "Replaced Section: " + this.getId();
        }

        public Image getImage() {
            return Activator.getImage("/icons/ReplacedSection.gif");
        }

        public IConfigurableDescriptor getDescriptor() {
            return null;
        }

        public String getEditionDialogId() {
            return "ReplacedSectionStateDialog";
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public Node generateNode(Document document) {
            Element node = document.createElement("replacedSection");
            node.setAttribute("id", this.id);
            return node;
        }

        public boolean isReadOnly() {
            return false;
        }

        public List<? extends ITraversableModelElement> getChildren() {
            return Collections.emptyList();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
            this.changeSupport.firePropertyChange("id", this.id, this.id);
        }

        public List<String> getAvailableId() {
            ArrayList<String> result = new ArrayList<String>();
            List<SectionSetDescriptorState> sectionSetDescriptorStates = StatesStore.getSectionSetDescriptorStates();
            for (SectionSetDescriptorState sectionSetDescriptorState : sectionSetDescriptorStates) {
                List<SectionDescriptorState> sectionDescriptorStates = sectionSetDescriptorState.getSectionDescriptorStates();
                for (SectionDescriptorState sectionDescriptorState : sectionDescriptorStates) {
                    result.add(sectionDescriptorState.getId());
                }
            }
            return result;
        }
    }
}

