/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.IEnhancedFilter;
import org.eclipse.papyrus.properties.tabbed.core.view.PropertyServiceUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionDispatcher {
    protected static SectionDispatcher instance;
    protected ISelection selection;
    protected List<DynamicSectionDescriptor> validSectionDescriptors;

    protected SectionDispatcher() {
    }

    public static synchronized SectionDispatcher getInstance() {
        if (instance == null) {
            instance = new SectionDispatcher();
        }
        return instance;
    }

    public boolean isSectionDisplayed(DynamicSectionDescriptor dynamicSectionDescriptor, Object objectToTest) {
        IEnhancedFilter filter = dynamicSectionDescriptor.getFilter();
        boolean enable = filter.selectWithoutVisibility(objectToTest);
        return enable;
    }

    public List<DynamicSectionDescriptor> getDisplayedSections(IWorkbenchPart part, ISelection selection) {
        if (selection == null) {
            this.validSectionDescriptors = new ArrayList<DynamicSectionDescriptor>();
        } else if (!selection.equals(this.selection)) {
            this.selection = selection;
            this.validSectionDescriptors = new ArrayList<DynamicSectionDescriptor>();
            ArrayList<DynamicSectionDescriptor> availableSectionDescriptors = new ArrayList<DynamicSectionDescriptor>();
            for (List<ITabDescriptor> tabDescriptors : PropertyServiceUtil.getTabDescriptors()) {
                for (ITabDescriptor tabDescriptor : tabDescriptors) {
                    for (Object e : tabDescriptor.getSectionDescriptors()) {
                        boolean enable;
                        ISectionDescriptor sectionDescriptor = (ISectionDescriptor)e;
                        if (!(sectionDescriptor instanceof DynamicSectionDescriptor) || !(enable = ((DynamicSectionDescriptor)sectionDescriptor).appliesToWithoutSectionInheritance(part, selection))) continue;
                        availableSectionDescriptors.add((DynamicSectionDescriptor)sectionDescriptor);
                    }
                }
            }
            for (DynamicSectionDescriptor currentDescriptor : availableSectionDescriptors) {
                boolean isRemoved = false;
                String currentId = currentDescriptor.getId();
                for (DynamicSectionDescriptor dynamicSectionDescriptor : availableSectionDescriptors) {
                    if (!dynamicSectionDescriptor.getReplacedSectionIds().contains(currentId)) continue;
                    isRemoved = true;
                }
                if (isRemoved) continue;
                this.validSectionDescriptors.add(currentDescriptor);
            }
        }
        return this.validSectionDescriptors;
    }
}

