/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.util.List;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptorState;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionSetDescriptor
implements IConfigurableDescriptor {
    private final List<DynamicSectionDescriptor> sectionDescriptors;
    private final List<IConstraintDescriptor> constraintDescriptors;
    private final String name;
    private final int selectionSize;

    public SectionSetDescriptor(String name, List<DynamicSectionDescriptor> sectionDescriptors, List<IConstraintDescriptor> constraintDescriptors, int selectionSize) {
        this.name = name;
        this.sectionDescriptors = sectionDescriptors;
        this.constraintDescriptors = constraintDescriptors;
        this.selectionSize = selectionSize;
    }

    public List<DynamicSectionDescriptor> getSectionDescriptors() {
        return this.sectionDescriptors;
    }

    public List<IConstraintDescriptor> getConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    public int getSelectionSize() {
        return this.selectionSize;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(": ");
        String metaclassName = "";
        for (IConstraintDescriptor constraintDescriptor : this.getConstraintDescriptors()) {
            if (!(constraintDescriptor instanceof ObjectTypeConstraintDescriptor)) continue;
            metaclassName = ((ObjectTypeConstraintDescriptor)constraintDescriptor).getElementClass().getCanonicalName();
        }
        buffer.append(metaclassName);
        int selectionSize = this.getSelectionSize();
        buffer.append(" [");
        buffer.append(selectionSize >= 0 ? Integer.valueOf(selectionSize) : "*");
        buffer.append(']');
        for (IConstraintDescriptor constraintDescriptor : this.getConstraintDescriptors()) {
            if (!(constraintDescriptor instanceof AppliedStereotypeConstraintDescriptor)) continue;
            buffer.append('<');
            buffer.append(((AppliedStereotypeConstraintDescriptor)constraintDescriptor).getStereotypeQualifiedNames());
            buffer.append('>');
        }
        return buffer.toString();
    }

    public Image getImage() {
        return Activator.getImage("/icons/SectionSet.gif");
    }

    public SectionSetDescriptorState createState(boolean readOnly) {
        return new SectionSetDescriptorState(this, readOnly);
    }
}

