/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.constraints.AppliedStereotypeConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintDescriptorState;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ObjectTypeConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionSetDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionSetDescriptorState
extends AbstractState {
    protected final List<SectionDescriptorState> sectionDescriptorStates = new ArrayList<SectionDescriptorState>();
    protected final List<ConstraintDescriptorState> constraintDescriptorStates = new ArrayList<ConstraintDescriptorState>();
    protected final SectionSetDescriptor sectionSetDescriptor;
    private String name;
    private int selectionSize;
    private PropertyChangeSupport changeSupport;

    public SectionSetDescriptor getDescriptor() {
        return this.sectionSetDescriptor;
    }

    public SectionSetDescriptorState(SectionSetDescriptor sectionSetDescriptor, boolean readOnly) {
        super(readOnly);
        this.sectionSetDescriptor = sectionSetDescriptor;
        this.name = sectionSetDescriptor.getName();
        this.selectionSize = sectionSetDescriptor.getSelectionSize();
        for (DynamicSectionDescriptor abstractSectionDescriptor : sectionSetDescriptor.getSectionDescriptors()) {
            SectionDescriptorState sectionState = abstractSectionDescriptor.createState(readOnly);
            this.sectionDescriptorStates.add(sectionState);
        }
        for (IConstraintDescriptor constraintDescriptor : sectionSetDescriptor.getConstraintDescriptors()) {
            ConstraintDescriptorState constraintState = constraintDescriptor.createState(readOnly);
            this.constraintDescriptorStates.add(constraintState);
        }
        this.changeSupport = new PropertyChangeSupport((Object)this);
    }

    public void setName(String name) {
        this.name = name;
        this.changeSupport.firePropertyChange("name", this.name, this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setSelectionSize(int selectionSize) {
        this.selectionSize = selectionSize;
        this.changeSupport.firePropertyChange("selectionSize", this.selectionSize, this.selectionSize);
    }

    public int getSelectionSize() {
        return this.selectionSize;
    }

    public String getLabel() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append(": ");
        String metaclassName = "";
        for (IConstraintDescriptor constraintDescriptor : this.getDescriptor().getConstraintDescriptors()) {
            if (!(constraintDescriptor instanceof ObjectTypeConstraintDescriptor)) continue;
            metaclassName = ((ObjectTypeConstraintDescriptor)constraintDescriptor).getElementClass().getCanonicalName();
        }
        buffer.append(metaclassName);
        buffer.append(" [");
        buffer.append(this.selectionSize >= 0 ? Integer.valueOf(this.selectionSize) : "*");
        buffer.append(']');
        for (IConstraintDescriptor constraintDescriptor : this.getDescriptor().getConstraintDescriptors()) {
            if (!(constraintDescriptor instanceof AppliedStereotypeConstraintDescriptor)) continue;
            buffer.append('<');
            buffer.append(((AppliedStereotypeConstraintDescriptor)constraintDescriptor).getStereotypeQualifiedNames());
            buffer.append('>');
        }
        return buffer.toString();
    }

    public List<ConstraintDescriptorState> getConstraintDescriptorStates() {
        return this.constraintDescriptorStates;
    }

    public List<SectionDescriptorState> getSectionDescriptorStates() {
        return this.sectionDescriptorStates;
    }

    public String getEditionDialogId() {
        return "SectionSetDescriptorStateDialog";
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public List<? extends ITraversableModelElement> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(this.getConstraintDescriptorStates());
        children.addAll(this.getSectionDescriptorStates());
        return children;
    }

    public void addSectionDescriptorState(SectionDescriptorState state) {
        this.sectionDescriptorStates.add(state);
        this.changeSupport.firePropertyChange("ADD_CHILD_EVENT", null, this.sectionDescriptorStates);
    }

    public void removeSectionDescriptorState(SectionDescriptorState state) {
        this.sectionDescriptorStates.remove((Object)state);
        this.changeSupport.firePropertyChange("REMOVE_CHILD_EVENT", null, this.sectionDescriptorStates);
    }

    public Node generateNode(Document document) {
        Node node;
        Element sectionSetDescriptorNode = document.createElement("sectionSet");
        sectionSetDescriptorNode.setAttribute("name", this.name);
        Element contextNode = document.createElement("context");
        contextNode.setAttribute("enablesFor", "" + this.selectionSize);
        for (ConstraintDescriptorState constraintState : this.getConstraintDescriptorStates()) {
            node = constraintState.generateNode(document);
            contextNode.appendChild(node);
        }
        sectionSetDescriptorNode.appendChild(contextNode);
        for (SectionDescriptorState sectionState : this.getSectionDescriptorStates()) {
            node = sectionState.generateNode(document);
            sectionSetDescriptorNode.appendChild(node);
        }
        return sectionSetDescriptorNode;
    }
}

