/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.IConfigurableDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.StatesStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabDescriptorState
extends AbstractState {
    protected ITabDescriptor tabDescriptor;
    private PropertyChangeSupport changeSupport;
    private String id;
    private String category;
    private String label;
    private String afterTab;

    public TabDescriptorState(ITabDescriptor tabDescriptor, boolean readOnly) {
        super(readOnly);
        this.tabDescriptor = tabDescriptor;
        this.id = tabDescriptor.getId();
        this.label = tabDescriptor.getLabel();
        this.afterTab = tabDescriptor.getAfterTab();
        this.category = tabDescriptor.getCategory();
        this.changeSupport = new PropertyChangeSupport((Object)this);
    }

    public ITabDescriptor getTabDescriptor() {
        return this.tabDescriptor;
    }

    public String getText() {
        return String.valueOf(this.label) + " (Caterory: " + this.category + ")";
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAfterTab() {
        return this.afterTab;
    }

    public String getCategory() {
        return this.category;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAfterTab(String afterTab) {
        this.afterTab = afterTab;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Image getImage() {
        return Activator.getImage("/icons/Tab.gif");
    }

    public IConfigurableDescriptor getDescriptor() {
        return null;
    }

    public String getEditionDialogId() {
        return "TabDescriptorStateDialog";
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Node generateNode(Document document) {
        Element tabDescriptorNode = document.createElement("tab");
        tabDescriptorNode.setAttribute("category", this.category);
        tabDescriptorNode.setAttribute("id", this.id);
        tabDescriptorNode.setAttribute("label", this.label);
        List<TabDescriptorState> tabDescriptorStates = StatesStore.getTabDescriptorStates();
        int index = tabDescriptorStates.indexOf((Object)this);
        if (index != 0) {
            tabDescriptorNode.setAttribute("afterTab", tabDescriptorStates.get((int)(index - 1)).id);
        }
        return tabDescriptorNode;
    }

    public List<? extends ITraversableModelElement> getChildren() {
        return Collections.emptyList();
    }
}

