/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.view.PropertyViewProviderParser;
import org.eclipse.papyrus.properties.runtime.view.XMLParseException;
import org.eclipse.papyrus.properties.runtime.view.XMLPropertyViewProvider;
import org.eclipse.papyrus.properties.tabbed.core.view.GetTabDescriptorsFromConfiguration;
import org.eclipse.papyrus.properties.tabbed.core.view.IPropertyTabViewProvider;
import org.eclipse.papyrus.properties.tabbed.core.view.PropertyTabViewProviderParser;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyTabViewProvider
extends XMLPropertyViewProvider
implements IPropertyTabViewProvider {
    protected List<ITabDescriptor> tabDescriptors = new ArrayList<ITabDescriptor>();
    protected IConfigurationElement properyViewContributionConfigurationElement;
    protected Bundle bundle;

    protected PropertyViewProviderParser createParser() {
        return new PropertyTabViewProviderParser(this.tabDescriptors);
    }

    public String getId() {
        return this.id;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetTabDescriptorsFromConfiguration) {
            return true;
        }
        return super.provides(operation);
    }

    @Override
    public List<ITabDescriptor> getTabDescriptors() {
        return this.tabDescriptors;
    }

    public void configure(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        this.bundle = Platform.getBundle((String)element.getContributor().getName());
        if (this.bundle == null) {
            Activator.log.warn("Ignoring extension " + element + ". Impossible to find bundle " + this.bundle);
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if ("PropertyViewContribution".equals(child.getName())) {
                this.properyViewContributionConfigurationElement = child;
                this.name = child.getAttribute("name");
                this.id = child.getAttribute("id");
                if (this.id == null) {
                    Activator.log.error("impossible to find id for this contribution: " + this.name, null);
                    return;
                }
                this.description = child.getAttribute("description");
                String iconPath = child.getAttribute("icon");
                if (iconPath != null) {
                    this.iconDescriptor = Activator.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                try {
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    String path = this.getCustomization(this.id);
                    InputStream stream = this.getConfigurationContent();
                    if (stream == null) {
                        throw new IOException("Impossible to load file: " + path);
                    }
                    Document document = documentBuilder.parse(stream);
                    this.getParser().parseXMLfile(document, this.predefinedFragments, this.predefinedDialogs);
                }
                catch (ParserConfigurationException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (SAXException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (XMLParseException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public InputStream getConfigurationContent() throws IOException {
        String path = this.getCustomization(this.id);
        InputStream stream = null;
        if (path != null) {
            Activator.log.debug("Loading local file for provider: " + this.id + " in: " + path);
            stream = this.getLocalXmlfileContent(this.properyViewContributionConfigurationElement, path, this.bundle);
        } else {
            stream = this.getXmlFile(this.properyViewContributionConfigurationElement, this.properyViewContributionConfigurationElement.getAttribute("path"), this.bundle);
        }
        if (stream == null) {
            throw new IOException("Impossible to load file: " + path);
        }
        return stream;
    }

    protected InputStream getLocalXmlfileContent(IConfigurationElement child, String path, Bundle bundle) throws FileNotFoundException {
        return new FileInputStream(this.getLocalXmlfile(path));
    }

    public File getLocalXmlfile(String path) {
        File file = Activator.getDefault().getStateLocation().append(path).toFile();
        return file;
    }

    protected XMLMemento getExistingCustomizations() {
        String sValue = this.getPreferenceStore().getString("propertyViewCustomizations");
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)"propertyViewCustomizations");
        }
        catch (WorkbenchException e) {
            Activator.log.error("Impossible to read preferences", (Throwable)e);
            return null;
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void saveCustomizations(XMLMemento rootMemento) {
        StringWriter writer = new StringWriter();
        try {
            rootMemento.save((Writer)writer);
            if (this.getPreferenceStore() != null) {
                this.getPreferenceStore().setValue("propertyViewCustomizations", writer.toString());
            }
        }
        catch (IOException e) {
            Activator.log.error("input/ouput exception", (Throwable)e);
        }
    }

    public String getCustomization(String providerId) {
        XMLMemento root = this.getExistingCustomizations();
        IMemento[] mementos = root.getChildren("propertyViewCustomization");
        int i = 0;
        while (i < mementos.length) {
            IMemento memento = mementos[i];
            String id = memento.getString("id");
            if (providerId.equals(id)) {
                return memento.getString("path");
            }
            ++i;
        }
        return null;
    }

    public void setConfigurationFile(File file) {
        XMLMemento root = this.getExistingCustomizations();
        IMemento memento = this.retrieveMemento(root);
        if (memento == null) {
            memento = this.createMemento(root);
        }
        this.updateMemento(memento, file.getName());
        this.saveCustomizations(root);
    }

    protected void updateMemento(IMemento memento, String filePath) {
        memento.putString("path", filePath);
    }

    protected IMemento createMemento(XMLMemento root) {
        IMemento newMemento = root.createChild("propertyViewCustomization");
        newMemento.putString("id", this.getId());
        return newMemento;
    }

    protected IMemento retrieveMemento(XMLMemento root) {
        IMemento[] mementos = root.getChildren("propertyViewCustomization");
        int i = 0;
        while (i < mementos.length) {
            IMemento memento = mementos[i];
            String id = memento.getString("id");
            if (this.getId().equals(id)) {
                return memento;
            }
            ++i;
        }
        return null;
    }
}

