/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view.subfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.AbstractContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSection;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSubFeatureSection
extends DynamicSection {
    protected List<Object> subElementsToEdit;
    protected final SubFeatureDescriptor subFeatureDescriptor;
    protected final int maxColumn;
    protected final SubFeatureContainerDescriptor subFeatureContainerDescriptor;

    public DynamicSubFeatureSection(List<IFragmentDescriptor> viewDescriptors, SubFeatureDescriptor subFeatureDescriptor, int maxColumn, SubFeatureContainerDescriptor subFeatureContainerDescriptor, String adapterId) {
        super(viewDescriptors, adapterId);
        this.subFeatureDescriptor = subFeatureDescriptor;
        this.maxColumn = maxColumn;
        this.subFeatureContainerDescriptor = subFeatureContainerDescriptor;
    }

    @Override
    protected void refreshDisplay(List<Object> newObjects) {
        if (!newObjects.isEmpty() && !newObjects.equals(this.objectsToEdit)) {
            this.objectsToEdit = newObjects;
            List<Object> subObjects = this.getSubFeatureDescriptor().getSubElementsToEdit(this.objectsToEdit);
            if (!subObjects.isEmpty() && !subObjects.equals(this.subElementsToEdit)) {
                this.subElementsToEdit = subObjects;
                for (AbstractContainerDescriptor container : this.containers) {
                    container.dispose();
                }
                this.containers.clear();
                this.subFeatureContainerDescriptor.disposeContainer();
                Composite mainComposite = this.subFeatureContainerDescriptor.createContainer(this.parent, this.getWidgetFactory());
                mainComposite.setLayout((Layout)new GridLayout(Math.min(this.maxColumn, this.subElementsToEdit.size()), true));
                GridData data = new GridData(4, 4, true, true);
                mainComposite.setLayoutData((Object)data);
                for (Object subElement : this.subElementsToEdit) {
                    for (IFragmentDescriptor viewDescriptor : this.fragmentDescriptors) {
                        for (AbstractContainerDescriptor descriptor : viewDescriptor.getContainerDescriptors()) {
                            descriptor.createContent(mainComposite, this.tabbedPropertySheetPage.getWidgetFactory(), Arrays.asList(subElement));
                            this.containers.add(descriptor);
                        }
                    }
                }
            }
        }
    }

    protected boolean isValid(Composite mainComposite) {
        return mainComposite != null && !mainComposite.isDisposed();
    }

    protected SubFeatureDescriptor getSubFeatureDescriptor() {
        return this.subFeatureDescriptor;
    }
}

