/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.tabbed.core.view.subfeatures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.Activator;
import org.eclipse.papyrus.properties.tabbed.core.view.DynamicSectionDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.SectionDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.DynamicSubFeatureSection;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptor;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureContainerDescriptorState;
import org.eclipse.papyrus.properties.tabbed.core.view.subfeatures.SubFeatureDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSubFeatureSectionDescriptor
extends DynamicSectionDescriptor {
    protected final int maxColumn;
    protected final SubFeatureDescriptor subFeatureDescriptor;
    protected final SubFeatureContainerDescriptor subFeatureContainerDescriptor;

    public DynamicSubFeatureSectionDescriptor(String id, String tabId, List<IConstraintDescriptor> constraints, int selectionSize, String adapterID, List<String> replacedSectionIds, String afterSectionId, List<IFragmentDescriptor> fragmentDescriptors, SubFeatureDescriptor subFeatureDescriptor, int maxColumn, SubFeatureContainerDescriptor containerDescriptor) {
        super(id, tabId, constraints, selectionSize, adapterID, replacedSectionIds, afterSectionId, fragmentDescriptors);
        this.maxColumn = maxColumn;
        this.subFeatureDescriptor = subFeatureDescriptor;
        this.subFeatureContainerDescriptor = containerDescriptor;
    }

    public SubFeatureDescriptor getSubFeatureDescriptor() {
        return this.subFeatureDescriptor;
    }

    public SubFeatureContainerDescriptor getSubFeatureContainerDescriptor() {
        return this.subFeatureContainerDescriptor;
    }

    @Override
    public ISection getSectionClass() {
        return new DynamicSubFeatureSection(this.fragmentDescriptors, this.subFeatureDescriptor, this.maxColumn, this.subFeatureContainerDescriptor, this.adapterId);
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    @Override
    public SubFeatureSectionDescriptorState createState(boolean readOnly) {
        return new SubFeatureSectionDescriptorState(this, readOnly);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubFeatureSectionDescriptorState
    extends SectionDescriptorState {
        private SubFeatureDescriptor.SubFeatureDescriptorState subFeatureDescriptorState;
        private SubFeatureContainerDescriptorState subFeatureContainerDescriptorState;
        private int maxColumn;
        private PropertyChangeSupport changeSupport;

        public SubFeatureSectionDescriptorState(DynamicSubFeatureSectionDescriptor sectionDescriptor, boolean readOnly) {
            super(sectionDescriptor, readOnly);
            this.maxColumn = sectionDescriptor.getMaxColumn();
            this.subFeatureDescriptorState = sectionDescriptor.getSubFeatureDescriptor().createState(readOnly);
            this.subFeatureContainerDescriptorState = sectionDescriptor.getSubFeatureContainerDescriptor().createState(readOnly);
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }

        @Override
        public String getEditionDialogId() {
            return "SubFeatureSectionDescriptorStateDialog";
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            super.addPropertyChangeListener(listener);
            this.changeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            super.removePropertyChangeListener(listener);
            this.changeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public List<? extends ITraversableModelElement> getChildren() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add((Object)this.subFeatureDescriptorState);
            list.add((Object)this.subFeatureContainerDescriptorState);
            list.addAll(super.getChildren());
            return list;
        }

        public SubFeatureDescriptor.SubFeatureDescriptorState getSubFeatureDescriptorState() {
            return this.subFeatureDescriptorState;
        }

        @Override
        public Node generateNode(Document document) {
            Element node = document.createElement("subFeatureSection");
            node.setAttribute("id", this.getId());
            node.setAttribute("tabId", this.getTargetTab());
            node.setAttribute("adapterId", this.getAdapterId());
            node.setAttribute("maxColumn", "" + this.maxColumn);
            node.appendChild(this.subFeatureDescriptorState.generateNode(document));
            node.appendChild(this.subFeatureContainerDescriptorState.generateNode(document));
            this.generateReplacedSectionStates(node, document);
            this.generateFragmentDescriptorStateNodes(node, document);
            return node;
        }

        public void setMaxColumn(int maxColumn) {
            this.maxColumn = maxColumn;
            this.changeSupport.firePropertyChange("maxColumn", this.maxColumn, this.maxColumn);
        }

        public int getMaxColumn() {
            return this.maxColumn;
        }

        @Override
        public String getText() {
            return "Sub-Feature Section: " + this.getId() + " in tab: " + this.getTargetTab() + " (max column:" + this.maxColumn + ")";
        }

        public Image getImage() {
            return Activator.getImage("/icons/Section.gif");
        }
    }
}

